/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.openapi.fromsmithy.protocols;

import java.util.Optional;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.openapi.fromsmithy.Context;
import software.amazon.smithy.openapi.model.ParameterObject;

final class ModelUtils {
    private ModelUtils() {
    }

    static <T extends Trait> Optional<T> getMemberTrait(Context context, Shape shape, Class<T> trait) {
        return shape.asMemberShape().flatMap(member -> member.getMemberTrait(context.getModel().getShapeIndex(), trait));
    }

    static String getMediaType(Context context, MemberShape member) {
        return ModelUtils.getMemberTrait(context, (Shape)member, MediaTypeTrait.class).map(StringTrait::getValue).orElseGet(() -> context.getModel().getShapeIndex().getShape(member.getTarget()).map(target -> {
            if (target.isStringShape()) {
                return "text/plain";
            }
            if (target.isBlobShape()) {
                return "application/octet-stream";
            }
            return "application/octet-stream";
        }).orElse("application/octet-stream"));
    }

    static ParameterObject.Builder createParameterMember(Context context, MemberShape member) {
        ParameterObject.Builder builder = ParameterObject.builder();
        builder.required(member.isRequired());
        builder.name(member.getMemberName());
        ModelUtils.getMemberTrait(context, (Shape)member, DocumentationTrait.class).map(StringTrait::getValue).ifPresent(builder::description);
        return builder;
    }

    static Schema.Builder convertSchemaToStringBuilder(Schema schema) {
        return schema.toBuilder().type("string").maximum(null).minimum(null).exclusiveMaximum(null).exclusiveMinimum(null).multipleOf(null).items(null).properties(null).required(null).propertyNames(null).oneOf(null).anyOf(null).not(null).ref(null).minProperties(null).maxProperties(null).minItems(null).maxItems(null);
    }
}

