/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.HttpBinding;
import software.amazon.smithy.model.knowledge.HttpBindingIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.pattern.SmithyPattern;
import software.amazon.smithy.model.pattern.UriPattern;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.EndpointTrait;
import software.amazon.smithy.model.traits.HostLabelTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.PatternTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public final class HttpUriConflictValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        if (!model.isTraitApplied(HttpTrait.class)) {
            return Collections.emptyList();
        }
        return model.shapes(ServiceShape.class).flatMap(shape -> this.validateService(model, (ServiceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(Model model, ServiceShape service) {
        ArrayList<OperationShape> operations = new ArrayList<OperationShape>();
        for (OperationShape operation : TopDownIndex.of(model).getContainedOperations(service)) {
            if (!operation.hasTrait(HttpTrait.class)) continue;
            operations.add(operation);
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (OperationShape operation : operations) {
            events.addAll(this.checkConflicts(model, operation, operation.expectTrait(HttpTrait.class), operations));
        }
        return events;
    }

    private List<ValidationEvent> checkConflicts(Model model, OperationShape operation, HttpTrait httpTrait, List<OperationShape> operations) {
        String method = httpTrait.getMethod();
        UriPattern pattern = httpTrait.getUri();
        ArrayList<Pair<ShapeId, UriPattern>> conflicts = new ArrayList<Pair<ShapeId, UriPattern>>();
        ArrayList<Pair<ShapeId, UriPattern>> allowableConflicts = new ArrayList<Pair<ShapeId, UriPattern>>();
        for (OperationShape other : operations) {
            HttpTrait otherHttpTrait;
            if (other == operation || !other.hasTrait(HttpTrait.class) || !(otherHttpTrait = other.expectTrait(HttpTrait.class)).getMethod().equals(method) || !otherHttpTrait.getUri().conflictsWith(pattern) || !this.endpointConflicts(model, operation, other)) continue;
            if (this.isAllowableConflict(model, operation, other)) {
                allowableConflicts.add((Pair<ShapeId, UriPattern>)Pair.of((Object)other.getId(), (Object)otherHttpTrait.getUri()));
                continue;
            }
            conflicts.add((Pair<ShapeId, UriPattern>)Pair.of((Object)other.getId(), (Object)otherHttpTrait.getUri()));
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        if (!conflicts.isEmpty()) {
            events.add(this.error(operation, this.formatConflicts(pattern, conflicts)));
        }
        if (!allowableConflicts.isEmpty()) {
            String message = this.formatConflicts(pattern, allowableConflicts) + ". Pattern traits applied to the label members prevent the label value from evaluating to a conflict, but this is still a poor design. If this is acceptable, this can be suppressed.";
            events.add(this.danger(operation, message));
        }
        return events;
    }

    private boolean endpointConflicts(Model model, OperationShape operation, OperationShape otherOperation) {
        SmithyPattern otherPrefix;
        if (!operation.hasTrait(EndpointTrait.ID) && !otherOperation.hasTrait(EndpointTrait.ID)) {
            return true;
        }
        if (operation.hasTrait(EndpointTrait.ID) ^ otherOperation.hasTrait(EndpointTrait.ID)) {
            return false;
        }
        SmithyPattern prefix = operation.getTrait(EndpointTrait.class).get().getHostPrefix();
        boolean allowable = !this.isAllowableConflict(model, prefix, operation, otherPrefix = otherOperation.getTrait(EndpointTrait.class).get().getHostPrefix(), otherOperation, this::getHostLabelPatterns);
        return allowable;
    }

    private boolean isAllowableConflict(Model model, OperationShape operation, OperationShape otherOperation) {
        UriPattern uriPattern = operation.getTrait(HttpTrait.class).get().getUri();
        UriPattern otherUriPattern = otherOperation.getTrait(HttpTrait.class).get().getUri();
        return this.isAllowableConflict(model, uriPattern, operation, otherUriPattern, otherOperation, this::getHttpLabelPatterns);
    }

    private boolean isAllowableConflict(Model model, SmithyPattern pattern, OperationShape operation, SmithyPattern otherPattern, OperationShape otherOperation, BiFunction<Model, OperationShape, Map<String, Pattern>> getLabelPatterns) {
        Map<SmithyPattern.Segment, SmithyPattern.Segment> conflictingLabelSegments = pattern.getConflictingLabelSegmentsMap(otherPattern);
        if (conflictingLabelSegments.isEmpty()) {
            return false;
        }
        Map<String, Pattern> labelPatterns = getLabelPatterns.apply(model, operation);
        Map<String, Pattern> otherLabelPatterns = getLabelPatterns.apply(model, otherOperation);
        return conflictingLabelSegments.entrySet().stream().filter(conflict -> ((SmithyPattern.Segment)conflict.getKey()).isLabel() != ((SmithyPattern.Segment)conflict.getValue()).isLabel()).allMatch(conflict -> {
            String staticSegment;
            Pattern p;
            if (((SmithyPattern.Segment)conflict.getKey()).isLabel()) {
                p = (Pattern)labelPatterns.get(((SmithyPattern.Segment)conflict.getKey()).getContent());
                staticSegment = ((SmithyPattern.Segment)conflict.getValue()).getContent();
            } else {
                p = (Pattern)otherLabelPatterns.get(((SmithyPattern.Segment)conflict.getValue()).getContent());
                staticSegment = ((SmithyPattern.Segment)conflict.getKey()).getContent();
            }
            if (p == null) {
                return false;
            }
            return !p.matcher(staticSegment).find();
        });
    }

    private Map<String, Pattern> getHttpLabelPatterns(Model model, OperationShape operation) {
        return HttpBindingIndex.of(model).getRequestBindings(operation).entrySet().stream().filter(entry -> ((HttpBinding)entry.getValue()).getLocation().equals((Object)HttpBinding.Location.LABEL)).flatMap(entry -> OptionalUtils.stream(((HttpBinding)entry.getValue()).getMember().getMemberTrait(model, PatternTrait.class).map(pattern -> Pair.of(entry.getKey(), (Object)pattern.getPattern())))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    private Map<String, Pattern> getHostLabelPatterns(Model model, OperationShape operation) {
        Optional<StructureShape> input = OperationIndex.of(model).getInput(operation);
        return input.map(structureShape -> structureShape.members().stream().filter(member -> member.hasTrait(HostLabelTrait.class)).filter(member -> member.hasTrait(PatternTrait.class)).collect(Collectors.toMap(MemberShape::getMemberName, shape -> shape.expectTrait(PatternTrait.class).getPattern()))).orElse(Collections.emptyMap());
    }

    private String formatConflicts(UriPattern pattern, List<Pair<ShapeId, UriPattern>> conflicts) {
        String conflictString = conflicts.stream().map(conflict -> String.format("`%s` (%s)", conflict.getLeft(), conflict.getRight())).sorted().collect(Collectors.joining(", "));
        return String.format("Operation URI, `%s`, conflicts with other operation URIs in the same service: [%s]", pattern, conflictString);
    }
}

