/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

abstract class FilteredPlugin<S extends Shape, N extends Node>
implements NodeValidatorPlugin {
    private final Class<S> shapeClass;
    private final Class<N> nodeClass;

    FilteredPlugin(Class<S> shapeClass, Class<N> nodeClass) {
        this.shapeClass = shapeClass;
        this.nodeClass = nodeClass;
    }

    @Override
    public final void apply(Shape shape, Node value, NodeValidatorPlugin.Context context, BiConsumer<FromSourceLocation, String> emitter) {
        if (this.shapeClass.isInstance(shape) && this.nodeClass.isInstance(value)) {
            this.check(shape, value, context, emitter);
        }
    }

    abstract void check(S var1, N var2, NodeValidatorPlugin.Context var3, BiConsumer<FromSourceLocation, String> var4);
}

