/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Optional;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class LengthTrait
extends AbstractTrait
implements ToSmithyBuilder<LengthTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#length");
    private final Long min;
    private final Long max;

    private LengthTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.min = builder.min;
        this.max = builder.max;
        if (this.max == null && this.min == null) {
            throw new SourceException("One of 'min' or 'max' must be provided.", this.getSourceLocation());
        }
    }

    public Optional<Long> getMin() {
        return Optional.ofNullable(this.min);
    }

    public Optional<Long> getMax() {
        return Optional.ofNullable(this.max);
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withOptionalMember("min", this.getMin().map(Node::from)).withOptionalMember("max", this.getMax().map(Node::from));
    }

    public Builder toBuilder() {
        return (Builder)LengthTrait.builder().min(this.min).max(this.max).sourceLocation(this.getSourceLocation());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public LengthTrait createTrait(ShapeId target, Node value) {
            ObjectNode objectNode = value.expectObjectNode();
            Long minValue = objectNode.getMember("min").map(v -> v.expectNumberNode().getValue().longValue()).orElse(null);
            Long maxValue = objectNode.getMember("max").map(v -> v.expectNumberNode().getValue().longValue()).orElse(null);
            return ((Builder)LengthTrait.builder().sourceLocation(value)).min(minValue).max(maxValue).build();
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<LengthTrait, Builder> {
        private Long min;
        private Long max;

        public Builder min(Long min) {
            this.min = min;
            return this;
        }

        public Builder max(Long max) {
            this.max = max;
            return this;
        }

        public LengthTrait build() {
            return new LengthTrait(this);
        }
    }
}

