/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public final class ExclusiveStructureMemberTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        HashSet<ShapeId> exclusiveMemberTraits = new HashSet<ShapeId>();
        HashSet<ShapeId> exclusiveTargetTraits = new HashSet<ShapeId>();
        for (Shape shape2 : model.getShapesWithTrait(TraitDefinition.class)) {
            TraitDefinition definition = shape2.expectTrait(TraitDefinition.class);
            if (definition.isStructurallyExclusiveByTarget()) {
                exclusiveTargetTraits.add(shape2.getId());
                continue;
            }
            if (!definition.isStructurallyExclusiveByMember()) continue;
            exclusiveMemberTraits.add(shape2.getId());
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        model.shapes(StructureShape.class).forEach(shape -> {
            this.validateExclusiveMembers((StructureShape)shape, (Set<ShapeId>)exclusiveMemberTraits, (List<ValidationEvent>)events);
            this.validateExclusiveTargets(model, (StructureShape)shape, (Set<ShapeId>)exclusiveTargetTraits, (List<ValidationEvent>)events);
        });
        return events;
    }

    private void validateExclusiveMembers(StructureShape shape, Set<ShapeId> exclusiveMemberTraits, List<ValidationEvent> events) {
        for (ShapeId traitId : exclusiveMemberTraits) {
            List matches = shape.getAllMembers().values().stream().filter(member -> member.findTrait(traitId).isPresent()).map(MemberShape::getMemberName).collect(Collectors.toList());
            if (matches.size() <= 1) continue;
            events.add(this.error(shape, String.format("The `%s` trait can be applied to only a single member of a structure, but it was found on the following members: %s", Trait.getIdiomaticTraitName(traitId), ValidationUtils.tickedList(matches))));
        }
    }

    private List<ValidationEvent> validateExclusiveTargets(Model model, StructureShape shape, Set<ShapeId> exclusiveTargets, List<ValidationEvent> events) {
        for (ShapeId id : exclusiveTargets) {
            List matches = shape.getAllMembers().values().stream().filter(member -> this.memberTargetHasTrait(model, (MemberShape)member, id)).map(MemberShape::getMemberName).collect(Collectors.toList());
            if (matches.size() <= 1) continue;
            events.add(this.error(shape, String.format("Only a single member of a structure can target a shape marked with the `%s` trait, but it was found on the following members: %s", Trait.getIdiomaticTraitName(id), ValidationUtils.tickedList(matches))));
        }
        return events;
    }

    private boolean memberTargetHasTrait(Model model, MemberShape member, ShapeId trait) {
        return model.getShape(member.getTarget()).flatMap(target -> target.findTrait(trait)).isPresent();
    }
}

