/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.ServiceIndex;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class AuthTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        model.shapes(ServiceShape.class).forEach(service -> this.validateService(model, (ServiceShape)service, (List<ValidationEvent>)events));
        return events;
    }

    private void validateService(Model model, ServiceShape service, List<ValidationEvent> events) {
        ServiceIndex serviceIndex = ServiceIndex.of(model);
        Set<ShapeId> serviceAuth = serviceIndex.getAuthSchemes(service).keySet();
        TopDownIndex topDownIndex = TopDownIndex.of(model);
        this.validateShape(serviceAuth, service, service, events);
        for (OperationShape operation : topDownIndex.getContainedOperations(service)) {
            this.validateShape(serviceAuth, service, operation, events);
        }
    }

    private void validateShape(Set<ShapeId> serviceAuth, ServiceShape service, Shape shape, List<ValidationEvent> events) {
        if (shape.getTrait(AuthTrait.class).isPresent()) {
            AuthTrait authTrait = shape.getTrait(AuthTrait.class).get();
            TreeSet<ShapeId> appliedAuthTraitValue = new TreeSet<ShapeId>(authTrait.getValues());
            appliedAuthTraitValue.removeAll(serviceAuth);
            if (!appliedAuthTraitValue.isEmpty()) {
                events.add(this.danger(shape, authTrait, String.format("auth trait applies authentication that is not configured on the service shape, `%s`: %s", service.getId(), appliedAuthTraitValue)));
            }
        }
    }
}

