/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.AbstractMutableModelFile;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.loader.TraitContainer;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.utils.Pair;

final class ForwardReferenceModelFile
extends AbstractMutableModelFile {
    private String namespace;
    private final Deque<Pair<String, BiConsumer<ShapeId, Function<ShapeId, ShapeType>>>> forwardReferences = new ArrayDeque<Pair<String, BiConsumer<ShapeId, Function<ShapeId, ShapeType>>>>();
    private final Map<String, Pair<ShapeId, SourceLocation>> useShapes = new HashMap<String, Pair<ShapeId, SourceLocation>>();

    ForwardReferenceModelFile(TraitFactory traitFactory) {
        super(traitFactory);
    }

    String namespace() {
        return this.namespace;
    }

    void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    void useShape(ShapeId id, SourceLocation location) {
        if (this.useShapes.containsKey(id.getName())) {
            ShapeId previous = (ShapeId)this.useShapes.get((Object)id.getName()).left;
            String message = String.format("Cannot use name `%s` because it conflicts with `%s`", id, previous);
            throw new ModelSyntaxException(message, location);
        }
        this.useShapes.put(id.getName(), (Pair<ShapeId, SourceLocation>)Pair.of((Object)id, (Object)location));
    }

    @Override
    void onShape(AbstractShapeBuilder<?, ?> builder) {
        if (this.useShapes.containsKey(builder.getId().getName())) {
            ShapeId previous = (ShapeId)this.useShapes.get((Object)builder.getId().getName()).left;
            String message = String.format("Shape name `%s` conflicts with imported shape `%s`", builder.getId().getName(), previous);
            throw new ModelSyntaxException(message, builder);
        }
        super.onShape(builder);
    }

    void addForwardReference(String name, Consumer<ShapeId> consumer) {
        this.forwardReferences.add((Pair<String, BiConsumer<ShapeId, Function<ShapeId, ShapeType>>>)Pair.of((Object)name, (id, typeProvider) -> consumer.accept((ShapeId)id)));
    }

    void addForwardReference(String name, BiConsumer<ShapeId, Function<ShapeId, ShapeType>> consumer) {
        this.forwardReferences.add((Pair<String, BiConsumer<ShapeId, Function<ShapeId, ShapeType>>>)Pair.of((Object)name, consumer));
    }

    @Override
    public TraitContainer resolveShapes(Set<ShapeId> ids, Function<ShapeId, ShapeType> typeProvider) {
        while (!this.forwardReferences.isEmpty()) {
            ShapeId resolved;
            Pair<String, BiConsumer<ShapeId, Function<ShapeId, ShapeType>>> pair = this.forwardReferences.pop();
            String name = (String)pair.left;
            BiConsumer consumer = (BiConsumer)pair.right;
            if (name.contains("#")) {
                resolved = ShapeId.from(name);
            } else if (this.useShapes.containsKey(name)) {
                resolved = (ShapeId)this.useShapes.get((Object)name).left;
            } else {
                ShapeId preludeTest;
                resolved = ShapeId.from(this.namespace() + "#" + name);
                if (!ids.contains(resolved) && ids.contains(preludeTest = ShapeId.from("smithy.api#" + name))) {
                    resolved = preludeTest;
                }
            }
            consumer.accept(resolved, typeProvider);
        }
        return this.traitContainer;
    }
}

