/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class MapLengthPlugin
extends MemberAndShapeTraitPlugin<MapShape, ObjectNode, LengthTrait> {
    MapLengthPlugin() {
        super(MapShape.class, ObjectNode.class, LengthTrait.class);
    }

    @Override
    protected void check(Shape shape, LengthTrait trait, ObjectNode node, Model model, BiConsumer<FromSourceLocation, String> emitter) {
        trait.getMin().ifPresent(min -> {
            if ((long)node.size() < min) {
                emitter.accept(node, String.format("Value provided for `%s` must have at least %d entries, but the provided value only has %d entries", shape.getId(), min, node.size()));
            }
        });
        trait.getMax().ifPresent(max -> {
            if ((long)node.size() > max) {
                emitter.accept(node, String.format("Value provided for `%s` must have no more than %d entries, but the provided value has %d entries", shape.getId(), max, node.size()));
            }
        });
    }
}

