/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;
import software.amazon.smithy.utils.SmithyInternalApi;

@SmithyInternalApi
final class BlobLengthPlugin
extends MemberAndShapeTraitPlugin<BlobShape, StringNode, LengthTrait> {
    BlobLengthPlugin() {
        super(BlobShape.class, StringNode.class, LengthTrait.class);
    }

    @Override
    protected void check(Shape shape, LengthTrait trait, StringNode node, Model model, BiConsumer<FromSourceLocation, String> emitter) {
        String value = node.getValue();
        int size = value.getBytes(Charset.forName("UTF-8")).length;
        trait.getMin().ifPresent(min -> {
            if ((long)size < min) {
                emitter.accept(node, "Value provided for `" + shape.getId() + "` must have at least " + min + " bytes, but the provided value only has " + size + " bytes");
            }
        });
        trait.getMax().ifPresent(max -> {
            if ((long)value.getBytes(Charset.forName("UTF-8")).length > max) {
                emitter.accept(node, "Value provided for `" + shape.getId() + "` must have no more than " + max + " bytes, but the provided value has " + size + " bytes");
            }
        });
    }
}

