/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.selector.AndSelector;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.ShapeTypeSelector;
import software.amazon.smithy.model.shapes.Shape;

final class WrappedSelector
implements Selector {
    private final String expression;
    private final InternalSelector delegate;
    private final Class<? extends Shape> startingShapeType;

    WrappedSelector(String expression, List<InternalSelector> selectors) {
        this.expression = expression;
        if (selectors.get(0) instanceof ShapeTypeSelector) {
            this.startingShapeType = ((ShapeTypeSelector)selectors.get((int)0)).shapeType.getShapeClass();
            this.delegate = AndSelector.of(selectors.subList(1, selectors.size()));
        } else {
            this.startingShapeType = null;
            this.delegate = AndSelector.of(selectors);
        }
    }

    public String toString() {
        return this.expression;
    }

    public boolean equals(Object other) {
        return other instanceof Selector && this.toString().equals(other.toString());
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    @Override
    public Set<Shape> select(Model model) {
        HashSet<Shape> result = new HashSet<Shape>();
        this.pushShapes(model, (ctx, s) -> {
            result.add(s);
            return true;
        });
        return result;
    }

    @Override
    public void consumeMatches(Model model, Consumer<Selector.ShapeMatch> shapeMatchConsumer) {
        this.pushShapes(model, (ctx, s) -> {
            shapeMatchConsumer.accept(new Selector.ShapeMatch(s, ctx.getVars()));
            return true;
        });
    }

    @Override
    public Stream<Shape> shapes(Model model) {
        Context context = this.createContext(model);
        return this.streamStartingShape(model).flatMap(shape -> {
            ArrayList result = new ArrayList();
            this.delegate.push(context.clearVars(), (Shape)shape, (ctx, s) -> {
                result.add(s);
                return true;
            });
            return result.stream();
        });
    }

    @Override
    public Stream<Selector.ShapeMatch> matches(Model model) {
        Context context = this.createContext(model);
        return this.streamStartingShape(model).flatMap(shape -> {
            ArrayList result = new ArrayList();
            this.delegate.push(context.clearVars(), (Shape)shape, (ctx, s) -> {
                result.add(new Selector.ShapeMatch(s, ctx.getVars()));
                return true;
            });
            return result.stream();
        });
    }

    private Context createContext(Model model) {
        return new Context(NeighborProviderIndex.of(model));
    }

    private void pushShapes(Model model, InternalSelector.Receiver acceptor) {
        Context context = this.createContext(model);
        if (this.startingShapeType != null) {
            model.shapes(this.startingShapeType).forEach(shape -> this.delegate.push(context.clearVars(), (Shape)shape, acceptor));
        } else {
            for (Shape shape2 : model.toSet()) {
                this.delegate.push(context.clearVars(), shape2, acceptor);
            }
        }
    }

    private Stream<? extends Shape> streamStartingShape(Model model) {
        return this.startingShapeType != null ? model.shapes(this.startingShapeType) : model.shapes();
    }
}

