/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeDeserializationException;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.StringUtils;

final class DefaultNodeDeserializers {
    private static final NodeMapper.ObjectCreatorFactory EXACT_CREATOR_FACTORY = (nodeType, targetType, nodeMapper) -> Node.class.isAssignableFrom(targetType) && targetType.isAssignableFrom(nodeType.getNodeClass()) ? (node, target, param, pointer, mapper) -> node : null;
    private static final NodeMapper.ObjectCreatorFactory BOOLEAN_CREATOR_FACTORY = (nodeType, targetType, nodeMapper) -> {
        if (nodeType == NodeType.BOOLEAN && (targetType == Boolean.class || targetType == Boolean.TYPE || targetType == Object.class)) {
            return (node, target, param, pointer, mapper) -> node.expectBooleanNode().getValue();
        }
        return null;
    };
    private static final NodeMapper.ObjectCreatorFactory NULL_CREATOR = (nodeType, targetType, nodeMapper) -> {
        if (nodeType == NodeType.NULL) {
            return (node, target, param, pointer, mapper) -> null;
        }
        return null;
    };
    private static final NodeMapper.ObjectCreatorFactory STRING_CREATOR = (nodeType, into, nodeMapper) -> {
        if (nodeType == NodeType.STRING) {
            if (into == String.class || into == Object.class) {
                return (node, target, param, pointer, mapper) -> node.expectStringNode().getValue();
            }
            if (into == ShapeId.class) {
                return (node, target, param, pointer, mapper) -> node.expectStringNode().expectShapeId();
            }
        }
        return null;
    };
    private static final Map<Class, Function<Number, Object>> NUMBER_MAPPERS = new HashMap<Class, Function<Number, Object>>();
    private static final NodeMapper.ObjectCreatorFactory NUMBER_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory COLLECTION_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory MAP_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory FROM_NODE_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory FROM_BUILDER_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory BEAN_CREATOR;
    private static final NodeMapper.ObjectCreatorFactory ENUM_CREATOR;
    private static final Map<Class, FromStringClassFactory> FROM_STRING_CLASSES;
    private static final NodeMapper.ObjectCreatorFactory FROM_STRING;
    private static final List<NodeMapper.ObjectCreatorFactory> DEFAULT_FACTORIES;
    static final NodeMapper.ObjectCreatorFactory DEFAULT_CHAIN;
    static final NodeMapper.ObjectCreatorFactory DEFAULT_CACHED_CREATOR;

    private static String getCauseMessage(Throwable e) {
        return e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
    }

    private static void applySourceLocation(Object object, FromSourceLocation sourceLocation) throws ReflectiveOperationException {
        Pair setter = BeanMapper.findSetter(object.getClass(), "sourceLocation");
        if (setter != null) {
            ((Method)setter.left).invoke(object, sourceLocation.getSourceLocation());
        }
    }

    private static NodeMapper.ObjectCreatorFactory cachedCreator(NodeMapper.ObjectCreatorFactory delegate) {
        ConcurrentHashMap cache = new ConcurrentHashMap();
        return (nodeType, target, nodeMapper) -> cache.computeIfAbsent(Pair.of((Object)((Object)nodeType), (Object)target), pair -> delegate.getCreator((NodeType)((Object)((Object)((Object)pair.left))), (Class)pair.right, nodeMapper));
    }

    private DefaultNodeDeserializers() {
    }

    static {
        NUMBER_MAPPERS.put(Object.class, n -> n);
        NUMBER_MAPPERS.put(Byte.class, Number::byteValue);
        NUMBER_MAPPERS.put(Byte.TYPE, Number::byteValue);
        NUMBER_MAPPERS.put(Short.class, Number::shortValue);
        NUMBER_MAPPERS.put(Short.TYPE, Number::shortValue);
        NUMBER_MAPPERS.put(Integer.class, Number::intValue);
        NUMBER_MAPPERS.put(Integer.TYPE, Number::intValue);
        NUMBER_MAPPERS.put(Long.class, Number::longValue);
        NUMBER_MAPPERS.put(Long.TYPE, Number::longValue);
        NUMBER_MAPPERS.put(Float.class, Number::floatValue);
        NUMBER_MAPPERS.put(Float.TYPE, Number::floatValue);
        NUMBER_MAPPERS.put(Double.class, Number::doubleValue);
        NUMBER_MAPPERS.put(Double.TYPE, Number::doubleValue);
        NUMBER_MAPPERS.put(BigInteger.class, n -> BigInteger.valueOf(n.longValue()));
        NUMBER_MAPPERS.put(BigDecimal.class, n -> BigDecimal.valueOf(n.doubleValue()));
        NUMBER_CREATOR = (nodeType, targetType, nodeMapper) -> {
            if (nodeType == NodeType.NUMBER && NUMBER_MAPPERS.containsKey(targetType)) {
                return (node, target, param, pointer, mapper) -> {
                    Number value = node.expectNumberNode().getValue();
                    return NUMBER_MAPPERS.get(target).apply(value);
                };
            }
            return null;
        };
        COLLECTION_CREATOR = new NodeMapper.ObjectCreatorFactory(){

            @Override
            public NodeMapper.ObjectCreator getCreator(NodeType nodeType, Class<?> target, NodeMapper nodeMapper) {
                if (nodeType != NodeType.ARRAY) {
                    return null;
                }
                ReflectiveSupplier<Collection<Object>> ctor = this.createSupplier(target);
                if (ctor == null) {
                    return null;
                }
                return (node, targetType, param, pointer, mapper) -> {
                    Collection collection;
                    try {
                        collection = (Collection)ctor.get();
                    }
                    catch (ReflectiveOperationException e) {
                        String message = "Unable to deserialize array into Collection: " + DefaultNodeDeserializers.getCauseMessage(e);
                        throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, message);
                    }
                    int i = 0;
                    for (Node entry : node.expectArrayNode().getElements()) {
                        Object nextValue = mapper.deserializeNext(entry, pointer + "/" + i++, param, Object.class, mapper);
                        collection.add(nextValue);
                    }
                    return collection;
                };
            }

            private ReflectiveSupplier<Collection<Object>> createSupplier(Class<?> targetType) {
                if (targetType.equals(List.class) || targetType.equals(Collection.class) || targetType.equals(Object.class) || targetType.equals(ArrayList.class) || targetType.equals(Iterable.class)) {
                    return ArrayList::new;
                }
                if (targetType.equals(Set.class) || targetType.equals(HashSet.class)) {
                    return HashSet::new;
                }
                if (Collection.class.isAssignableFrom(targetType)) {
                    return this.createSupplierFromReflection(targetType);
                }
                return null;
            }

            private ReflectiveSupplier<Collection<Object>> createSupplierFromReflection(Class<?> into) {
                try {
                    Class<?> collectionTarget = into;
                    Constructor<?> classCtor = collectionTarget.getDeclaredConstructor(new Class[0]);
                    classCtor.setAccessible(true);
                    return () -> (Collection)classCtor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new NodeDeserializationException("Unable to find a zero-arg constructor for Collection " + into.getName(), SourceLocation.NONE, (Throwable)e);
                }
            }
        };
        MAP_CREATOR = new NodeMapper.ObjectCreatorFactory(){

            @Override
            public NodeMapper.ObjectCreator getCreator(NodeType nodeType, Class<?> target, NodeMapper nodeMapper) {
                if (nodeType != NodeType.OBJECT) {
                    return null;
                }
                ReflectiveSupplier<Map<String, Object>> ctor = this.createSupplier(target);
                if (ctor == null) {
                    return null;
                }
                return (node, targetType, param, pointer, mapper) -> {
                    Map map;
                    try {
                        map = (Map)ctor.get();
                    }
                    catch (ReflectiveOperationException e) {
                        String message = "Unable to deserialize object into Map: " + DefaultNodeDeserializers.getCauseMessage(e);
                        throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, message);
                    }
                    ObjectNode objectNode = node.expectObjectNode();
                    for (Map.Entry<String, Node> entry : objectNode.getStringMap().entrySet()) {
                        String key = entry.getKey();
                        Object value = mapper.deserializeNext(entry.getValue(), pointer + "/" + key, param, Object.class, mapper);
                        map.put(key, value);
                    }
                    return map;
                };
            }

            private ReflectiveSupplier<Map<String, Object>> createSupplier(Class<?> into) {
                if (into == Object.class || into == Map.class || into == HashMap.class) {
                    return HashMap::new;
                }
                if (Map.class.isAssignableFrom(into)) {
                    return this.createSupplierFromReflection(into);
                }
                return null;
            }

            private ReflectiveSupplier<Map<String, Object>> createSupplierFromReflection(Class<?> into) {
                try {
                    Class<?> collectionTarget = into;
                    Constructor<?> mapCtor = collectionTarget.getDeclaredConstructor(new Class[0]);
                    return () -> (Map)mapCtor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new NodeDeserializationException("Unable to find a zero-arg constructor for Map " + into.getName(), SourceLocation.NONE, (Throwable)e);
                }
            }
        };
        FROM_NODE_CREATOR = (nodeType, target, nodeMapper) -> {
            if (!nodeMapper.getDisableFromNode().contains(target)) {
                for (Method method : target.getMethods()) {
                    if (!method.getName().equals("fromNode") || !target.isAssignableFrom(method.getReturnType()) || method.getParameters().length != 1 || !Node.class.isAssignableFrom(method.getParameters()[0].getType()) || !Modifier.isStatic(method.getModifiers())) continue;
                    return (node, targetType, paramType, pointer, mapper) -> {
                        try {
                            return method.invoke(null, node);
                        }
                        catch (ReflectiveOperationException e) {
                            String message = "Unable to deserialize Node using fromNode method: " + DefaultNodeDeserializers.getCauseMessage(e);
                            throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, message);
                        }
                    };
                }
            }
            return null;
        };
        FROM_BUILDER_CREATOR = (nodeType, target, nodeMapper) -> {
            if (nodeType != NodeType.OBJECT) {
                return null;
            }
            for (Method method : target.getMethods()) {
                if (!method.getName().equals("builder") || !SmithyBuilder.class.isAssignableFrom(method.getReturnType()) || method.getParameters().length != 0 || !Modifier.isStatic(method.getModifiers())) continue;
                method.setAccessible(true);
                return (node, targetType, paramType, pointer, mapper) -> {
                    try {
                        SmithyBuilder builder = (SmithyBuilder)method.invoke(null, new Object[0]);
                        BeanMapper.apply(builder, node, builder.getClass(), pointer, mapper);
                        DefaultNodeDeserializers.applySourceLocation(builder, node);
                        return builder.build();
                    }
                    catch (ReflectiveOperationException e) {
                        String message = "Unable to deserialize Node using a builder: " + DefaultNodeDeserializers.getCauseMessage(e);
                        throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, message);
                    }
                };
            }
            return null;
        };
        BEAN_CREATOR = (nodeType, target, nodeMapper) -> {
            if (nodeType != NodeType.OBJECT) {
                return null;
            }
            try {
                if (target.getEnclosingClass() != null && !Modifier.isStatic(target.getModifiers())) {
                    throw new NodeDeserializationException("Cannot create non-static inner class: " + target.getCanonicalName(), SourceLocation.NONE);
                }
                Constructor ctor = target.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                return (node, targetType, parameterizedType, pointer, mapper) -> {
                    try {
                        Object value = ctor.newInstance(new Object[0]);
                        BeanMapper.apply(value, node, targetType, pointer, mapper);
                        DefaultNodeDeserializers.applySourceLocation(value, node);
                        return value;
                    }
                    catch (ReflectiveOperationException e) {
                        throw NodeDeserializationException.fromReflectiveContext(targetType, pointer, node, e, "Unable to deserialize a Node when invoking target constructor: " + DefaultNodeDeserializers.getCauseMessage(e));
                    }
                };
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        };
        ENUM_CREATOR = (nodeType, target, nodeMapper) -> {
            if (nodeType != NodeType.STRING || !Enum.class.isAssignableFrom(target)) {
                return null;
            }
            return (node, targetType, parameterizedType, pointer, mapper) -> {
                String name = node.expectStringNode().getValue();
                for (Object constant : targetType.getEnumConstants()) {
                    if (!constant.toString().equals(name)) continue;
                    return constant;
                }
                ArrayList<String> names = new ArrayList<String>();
                for (Object constant : targetType.getEnumConstants()) {
                    names.add(constant.toString());
                }
                throw NodeDeserializationException.fromContext(targetType, pointer, node, null, "Expected one of the following enum strings: " + names);
            };
        };
        FROM_STRING_CLASSES = MapUtils.of(URL.class, URL::new, URI.class, URI::new, Pattern.class, Pattern::compile, Path.class, x$0 -> Paths.get(x$0, new String[0]), File.class, File::new);
        FROM_STRING = (nodeType, target, nodeMapper) -> {
            if (nodeType != NodeType.STRING || !FROM_STRING_CLASSES.containsKey(target)) {
                return null;
            }
            FromStringClassFactory factory = FROM_STRING_CLASSES.get(target);
            return (node, targetType, parameterizedType, pointer, mapper) -> {
                String value = node.expectStringNode().getValue();
                try {
                    return factory.create(value);
                }
                catch (Exception e) {
                    throw NodeDeserializationException.fromContext(targetType, pointer, node, e, e.getMessage());
                }
            };
        };
        DEFAULT_FACTORIES = ListUtils.of((Object[])new NodeMapper.ObjectCreatorFactory[]{EXACT_CREATOR_FACTORY, NULL_CREATOR, FROM_NODE_CREATOR, BOOLEAN_CREATOR_FACTORY, FROM_STRING, STRING_CREATOR, ENUM_CREATOR, NUMBER_CREATOR, COLLECTION_CREATOR, MAP_CREATOR, FROM_BUILDER_CREATOR, BEAN_CREATOR});
        DEFAULT_CHAIN = (nodeType, target, nodeMapper) -> {
            for (NodeMapper.ObjectCreatorFactory factory : DEFAULT_FACTORIES) {
                NodeMapper.ObjectCreator result = factory.getCreator(nodeType, target, nodeMapper);
                if (result == null) continue;
                return result;
            }
            return null;
        };
        DEFAULT_CACHED_CREATOR = DefaultNodeDeserializers.cachedCreator(DEFAULT_CHAIN);
    }

    private static interface FromStringClassFactory {
        public Object create(String var1) throws Exception;
    }

    static final class BeanMapper {
        private static final ConcurrentMap<Pair<Class<?>, String>, Pair<Method, Class>> SETTER_CACHE = new ConcurrentHashMap();

        BeanMapper() {
        }

        static void apply(Object value, Node node, Class<?> target, String pointer, NodeMapper mapper) throws ReflectiveOperationException {
            for (Map.Entry<String, Node> entry : node.expectObjectNode().getStringMap().entrySet()) {
                Pair<Method, Class> setterPair = BeanMapper.findSetter(target, entry.getKey());
                if (setterPair == null) {
                    mapper.getWhenMissingSetter().handle(target, pointer, entry.getKey(), entry.getValue());
                    continue;
                }
                Method method = (Method)setterPair.getLeft();
                Class parameterizedType = (Class)setterPair.getRight();
                Object member = mapper.deserializeNext(entry.getValue(), pointer + "/" + entry.getKey(), method.getParameters()[0].getType(), parameterizedType, mapper);
                method.invoke(value, member);
            }
        }

        private static Pair<Method, Class> findSetter(Class<?> type, String memberName) {
            return SETTER_CACHE.computeIfAbsent(Pair.of(type, (Object)memberName), pair -> {
                String sanitized = BeanMapper.sanitizePropertyName((String)pair.right);
                if (sanitized == null) {
                    return null;
                }
                Class target = (Class)pair.left;
                for (Method method : target.getMethods()) {
                    if (!BeanMapper.isBeanOrBuilderSetter(method, target, sanitized)) continue;
                    Class<?> parameterizedType = BeanMapper.determineParameterizedType(method);
                    return Pair.of((Object)method, parameterizedType);
                }
                return null;
            });
        }

        private static String sanitizePropertyName(String value) {
            StringBuilder result = new StringBuilder(value.length());
            boolean nextUpper = false;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    if (nextUpper) {
                        return null;
                    }
                    nextUpper = true;
                    continue;
                }
                if (nextUpper) {
                    nextUpper = false;
                    result.append(Character.toUpperCase(c));
                    continue;
                }
                result.append(c);
            }
            return result.toString();
        }

        private static boolean isBeanOrBuilderSetter(Method method, Class<?> type, String propertyName) {
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            Parameter[] parameters = method.getParameters();
            if (parameters.length != 1) {
                return false;
            }
            if (method.getReturnType() != Void.TYPE && method.getReturnType() != type) {
                return false;
            }
            if (method.getName().equals(propertyName)) {
                return true;
            }
            return method.getName().equals("set" + StringUtils.capitalize((String)propertyName));
        }

        private static Class<?> determineParameterizedType(Method setter) {
            Type genericParameters = setter.getGenericParameterTypes()[0];
            Class<?> containingType = setter.getParameterTypes()[0];
            if (genericParameters instanceof ParameterizedType) {
                Type[] parameterArgTypes = ((ParameterizedType)genericParameters).getActualTypeArguments();
                if (BeanMapper.isSupportedCollectionType(containingType, parameterArgTypes)) {
                    return BeanMapper.resolveClassFromType(parameterArgTypes[0]);
                }
                if (BeanMapper.isSupportedMapType(containingType, parameterArgTypes)) {
                    return BeanMapper.resolveClassFromType(parameterArgTypes[1]);
                }
            }
            return Object.class;
        }

        private static boolean isSupportedCollectionType(Class<?> containingType, Type[] parameterArgTypes) {
            return parameterArgTypes.length == 1 && Collection.class.isAssignableFrom(containingType);
        }

        private static boolean isSupportedMapType(Class<?> containingType, Type[] parameterArgTypes) {
            return parameterArgTypes.length == 2 && Map.class.isAssignableFrom(containingType) && parameterArgTypes[0] == String.class;
        }

        private static Class<?> resolveClassFromType(Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof WildcardType) {
                return BeanMapper.resolveClassFromType(((WildcardType)type).getUpperBounds()[0]);
            }
            if (type instanceof TypeVariable) {
                throw new IllegalArgumentException("TypeVariable targets are not implemented: " + type);
            }
            if (type instanceof GenericArrayType) {
                throw new IllegalArgumentException("GenericArrayType targets are not implemented: " + type);
            }
            throw new IllegalArgumentException("Unable to determine target Class from " + type);
        }
    }

    private static interface ReflectiveSupplier<T> {
        public T get() throws ReflectiveOperationException;
    }
}

