/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.HashSet;
import java.util.Set;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.SparseTrait;
import software.amazon.smithy.utils.SetUtils;

public class NullableIndex
implements KnowledgeIndex {
    private static final Set<ShapeType> INHERENTLY_BOXED = SetUtils.of((Object[])new ShapeType[]{ShapeType.STRING, ShapeType.BLOB, ShapeType.TIMESTAMP, ShapeType.BIG_DECIMAL, ShapeType.BIG_INTEGER, ShapeType.LIST, ShapeType.SET, ShapeType.MAP, ShapeType.STRUCTURE, ShapeType.UNION});
    private final Set<ShapeId> nullableShapes = new HashSet<ShapeId>();

    public NullableIndex(Model model) {
        for (Shape shape : model.toSet()) {
            if (shape.asMemberShape().isPresent()) {
                if (!NullableIndex.isMemberNullable(model, shape.asMemberShape().get())) continue;
                this.nullableShapes.add(shape.getId());
                continue;
            }
            if (!NullableIndex.isShapeBoxed(shape)) continue;
            this.nullableShapes.add(shape.getId());
        }
    }

    public static NullableIndex of(Model model) {
        return model.getKnowledge(NullableIndex.class, NullableIndex::new);
    }

    private static boolean isMemberNullable(Model model, MemberShape member) {
        Shape container = model.getShape(member.getContainer()).orElse(null);
        if (container == null) {
            return false;
        }
        switch (container.getType()) {
            case STRUCTURE: {
                return member.hasTrait(BoxTrait.class) || model.getShape(member.getTarget()).filter(NullableIndex::isShapeBoxed).isPresent();
            }
            case MAP: {
                if (member.getMemberName().equals("key")) {
                    return false;
                }
            }
            case LIST: {
                return container.hasTrait(SparseTrait.class);
            }
        }
        return false;
    }

    private static boolean isShapeBoxed(Shape shape) {
        return INHERENTLY_BOXED.contains((Object)shape.getType()) || shape.hasTrait(BoxTrait.class);
    }

    public final boolean isNullable(ToShapeId shape) {
        return this.nullableShapes.contains(shape.toShapeId());
    }
}

