/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TraitTargetValidator
extends AbstractValidator {
    private static final Pattern SANITIZE = Pattern.compile("\n\\s*");

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        HashMap selectorsToTraits = new HashMap();
        for (ShapeId shapeId : model.getAppliedTraits()) {
            model.getShape(shapeId).ifPresent(traitShape -> {
                Set<Shape> shapes = model.getShapesWithTrait(traitId);
                this.validateMixinsUsedAsTraits((Shape)traitShape, shapes, (List<ValidationEvent>)events);
                traitShape.getTrait(TraitDefinition.class).ifPresent(definition -> {
                    if (!definition.getSelector().toString().equals("*")) {
                        selectorsToTraits.computeIfAbsent(definition.getSelector(), selector -> new ArrayList()).add(traitId);
                    }
                });
            });
        }
        for (Map.Entry entry : selectorsToTraits.entrySet()) {
            this.validateTraitTargets(model, events, (Selector)entry.getKey(), (List)entry.getValue());
        }
        return events;
    }

    private void validateMixinsUsedAsTraits(Shape traitShape, Set<Shape> appliedTo, List<ValidationEvent> events) {
        if (traitShape.hasTrait(MixinTrait.ID)) {
            for (Shape shape : appliedTo) {
                events.add(this.error(shape, String.format("Trait `%s` is a mixin and cannot be applied to `%s`.", Trait.getIdiomaticTraitName(traitShape.getId()), shape.getId())));
            }
        }
    }

    private void validateTraitTargets(Model model, List<ValidationEvent> events, Selector selector, List<ShapeId> traits) {
        Set<Shape> matches = selector.select(model);
        for (ShapeId traitId : traits) {
            for (Shape shape : model.getShapesWithTrait(traitId)) {
                if (matches.contains(shape)) continue;
                String sanitized = SANITIZE.matcher(selector.toString()).replaceAll(" ");
                events.add(this.error(shape, shape.findTrait(traitId).get(), String.format("Trait `%s` cannot be applied to `%s`. This trait may only be applied to shapes that match the following selector: %s", Trait.getIdiomaticTraitName(traitId), shape.getId(), sanitized)));
            }
        }
    }
}

