/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.SetUtils;

public final class DefaultValueInUpdateValidator
extends AbstractValidator {
    private static final Set<String> OPERATION_NAMES_TO_CHECK = SetUtils.of((Object[])new String[]{"update", "patch"});

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        TreeSet<String> defaultedMembers = new TreeSet<String>();
        for (OperationShape operation : this.identifyOperations(model)) {
            StructureShape input = model.expectShape(operation.getInputShape(), StructureShape.class);
            for (MemberShape member : input.getAllMembers().values()) {
                if (!member.hasTrait(DefaultTrait.ID)) continue;
                defaultedMembers.add(member.getMemberName());
            }
            if (defaultedMembers.isEmpty()) continue;
            events.add(this.warning(operation, "This update style operation has top-level input members marked with the @default trait. It will be impossible to tell if the member was omitted or explicitly provided. Affected members: " + defaultedMembers));
            defaultedMembers.clear();
        }
        return events;
    }

    private Set<OperationShape> identifyOperations(Model model) {
        HashSet<OperationShape> operationsToCheck = new HashSet<OperationShape>();
        for (ResourceShape resource : model.getResourceShapes()) {
            resource.getUpdate().ifPresent(id -> operationsToCheck.add(model.expectShape((ShapeId)id, OperationShape.class)));
        }
        block1: for (OperationShape operation : model.getOperationShapes()) {
            String name = operation.getId().getName().toLowerCase(Locale.ENGLISH);
            for (String prefix : OPERATION_NAMES_TO_CHECK) {
                if (!name.startsWith(prefix)) continue;
                operationsToCheck.add(operation);
                continue block1;
            }
        }
        return operationsToCheck;
    }
}

