/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;

public final class CleanStructureAndUnionMembers
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> removed, Model model) {
        Model result = this.removeMembersFromContainers(transformer, removed, model);
        return transformer.removeShapes(result, this.findMembersThatNeedRemoval(result, removed));
    }

    private Model removeMembersFromContainers(ModelTransformer transformer, Collection<Shape> removed, Model model) {
        ArrayList<Shape> replacements = new ArrayList<Shape>(this.getStructureReplacements(model, removed));
        replacements.addAll(this.getUnionReplacements(model, removed));
        replacements.addAll(this.getEnumReplacements(model, removed));
        replacements.addAll(this.getIntEnumReplacements(model, removed));
        return transformer.replaceShapes(model, replacements);
    }

    private Collection<Shape> getEnumReplacements(Model model, Collection<Shape> removed) {
        return this.createUpdatedShapes(model, removed, Shape::asEnumShape, entry -> {
            EnumShape.Builder builder = ((EnumShape)entry.getKey()).toBuilder();
            for (MemberShape member : (List)entry.getValue()) {
                builder.removeMember(member.getMemberName());
            }
            return builder.build();
        });
    }

    private Collection<Shape> getIntEnumReplacements(Model model, Collection<Shape> removed) {
        return this.createUpdatedShapes(model, removed, Shape::asIntEnumShape, entry -> {
            IntEnumShape.Builder builder = ((IntEnumShape)entry.getKey()).toBuilder();
            for (MemberShape member : (List)entry.getValue()) {
                builder.removeMember(member.getMemberName());
            }
            return builder.build();
        });
    }

    private Collection<Shape> getStructureReplacements(Model model, Collection<Shape> removed) {
        return this.createUpdatedShapes(model, removed, Shape::asStructureShape, entry -> {
            StructureShape.Builder builder = ((StructureShape)entry.getKey()).toBuilder();
            for (MemberShape member : (List)entry.getValue()) {
                builder.removeMember(member.getMemberName());
            }
            return builder.build();
        });
    }

    private Collection<Shape> getUnionReplacements(Model model, Collection<Shape> removed) {
        return this.createUpdatedShapes(model, removed, Shape::asUnionShape, entry -> {
            UnionShape.Builder builder = ((UnionShape)entry.getKey()).toBuilder();
            for (MemberShape member : (List)entry.getValue()) {
                builder.removeMember(member.getMemberName());
            }
            return builder.build();
        });
    }

    private <S extends Shape> Collection<Shape> createUpdatedShapes(Model model, Collection<Shape> removed, Function<Shape, Optional<S>> containerShapeMapper, Function<Map.Entry<S, List<MemberShape>>, S> entryMapperAndFactory) {
        HashMap<Shape, List> containerMemberMap = new HashMap<Shape, List>();
        for (Shape shape : removed) {
            MemberShape member;
            Optional<S> container;
            if (!shape.isMemberShape() || !(container = model.getShape((member = (MemberShape)shape).getContainer()).flatMap(containerShapeMapper)).isPresent()) continue;
            containerMemberMap.computeIfAbsent((Shape)container.get(), k -> new ArrayList()).add(member);
        }
        ArrayList<Shape> updatedShapes = new ArrayList<Shape>();
        for (Map.Entry entry : containerMemberMap.entrySet()) {
            updatedShapes.add((Shape)entryMapperAndFactory.apply(entry));
        }
        return updatedShapes;
    }

    private Collection<Shape> findMembersThatNeedRemoval(Model model, Collection<Shape> removed) {
        HashSet<ShapeId> removedIds = new HashSet<ShapeId>();
        for (Shape shape : removed) {
            removedIds.add(shape.getId());
        }
        HashSet<Shape> removeMembers = new HashSet<Shape>();
        for (StructureShape structureShape : model.getStructureShapes()) {
            for (MemberShape member : structureShape.members()) {
                if (!removedIds.contains(member.getTarget())) continue;
                removeMembers.add(member);
            }
        }
        for (UnionShape unionShape : model.getUnionShapes()) {
            for (MemberShape member : unionShape.members()) {
                if (!removedIds.contains(member.getTarget())) continue;
                removeMembers.add(member);
            }
        }
        return removeMembers;
    }
}

