/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.HashSet;
import java.util.LinkedHashSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;

final class CopyServiceErrorsToOperationsTransform {
    private final ServiceShape forService;

    CopyServiceErrorsToOperationsTransform(ServiceShape forService) {
        this.forService = forService;
    }

    Model transform(ModelTransformer transformer, Model model) {
        if (this.forService.getErrorsSet().isEmpty()) {
            return model;
        }
        HashSet<OperationShape> toReplace = new HashSet<OperationShape>();
        TopDownIndex topDownIndex = TopDownIndex.of(model);
        for (OperationShape operation : topDownIndex.getContainedOperations(this.forService)) {
            LinkedHashSet<ShapeId> errors = new LinkedHashSet<ShapeId>(operation.getErrorsSet());
            errors.addAll(this.forService.getErrorsSet());
            toReplace.add(operation.toBuilder().errors(errors).build());
        }
        return transformer.replaceShapes(model, toReplace);
    }
}

