/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.UnstableTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class UnstableTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>(0);
        for (Shape trait : model.getShapesWithTrait(UnstableTrait.class)) {
            for (Shape appliedTo : model.getShapesWithTrait(trait)) {
                events.add(this.warning(appliedTo, appliedTo.findTrait(trait.getId()).get(), String.format("This shape applies a trait that is unstable: %s", trait.toShapeId()), trait.toShapeId().toString()));
            }
        }
        return events;
    }
}

