/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.PathFinder;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.FunctionalUtils;

public final class ShapeRecursionValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        PathFinder finder = PathFinder.create(model);
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        this.validateListMapSetShapes(finder, model, events);
        this.validateStructurePaths(finder, model, events);
        this.validateUnions(model, events);
        return events;
    }

    private void validateListMapSetShapes(PathFinder finder, Model model, List<ValidationEvent> events) {
        finder.relationshipFilter(rel -> !rel.getShape().isStructureShape() && !rel.getShape().isUnionShape());
        for (ListShape listShape : model.getListShapes()) {
            this.validateListMapSetShapes(listShape, finder, events);
        }
        for (SetShape setShape : model.getSetShapes()) {
            this.validateListMapSetShapes(setShape, finder, events);
        }
        for (MapShape mapShape : model.getMapShapes()) {
            this.validateListMapSetShapes(mapShape, finder, events);
        }
        finder.relationshipFilter(FunctionalUtils.alwaysTrue());
    }

    private void validateListMapSetShapes(Shape shape, PathFinder finder, List<ValidationEvent> events) {
        for (PathFinder.Path path : finder.search((ToShapeId)shape, Collections.singletonList(shape))) {
            events.add(this.error(shape, String.format("Found invalid shape recursion: %s. A recursive list, set, or map shape is only valid if an intermediate reference is through a union or structure.", this.formatPath(path))));
        }
    }

    private void validateStructurePaths(PathFinder finder, Model model, List<ValidationEvent> events) {
        finder.relationshipFilter(rel -> {
            if (rel.getShape().isStructureShape()) {
                return rel.getNeighborShape().get().hasTrait(RequiredTrait.ID);
            }
            return rel.getShape().isMemberShape();
        });
        for (StructureShape shape : model.getStructureShapes()) {
            for (PathFinder.Path path : finder.search((ToShapeId)shape, Collections.singletonList(shape))) {
                events.add(this.error(shape, String.format("Found invalid shape recursion: %s. A structure cannot be mutually recursive through all required members.", this.formatPath(path))));
            }
        }
    }

    private String formatPath(PathFinder.Path path) {
        StringJoiner joiner = new StringJoiner(" > ");
        List<Shape> shapes = path.getShapes();
        for (int i = 0; i < shapes.size(); ++i) {
            if (i <= 0) continue;
            joiner.add(shapes.get(i).getId().toString());
        }
        return joiner.toString();
    }

    private void validateUnions(Model model, List<ValidationEvent> events) {
        UnionTerminatesVisitor visitor = new UnionTerminatesVisitor(model);
        for (UnionShape union : model.getUnionShapes()) {
            if (!union.members().isEmpty() && !union.accept(visitor).booleanValue()) {
                events.add(this.error(union, "It is impossible to create instances of this recursive union"));
            }
            visitor.reset();
        }
    }

    private static final class UnionTerminatesVisitor
    extends ShapeVisitor.Default<Boolean> {
        private final Set<MemberShape> visited = new HashSet<MemberShape>();
        private final Model model;

        UnionTerminatesVisitor(Model model) {
            this.model = model;
        }

        void reset() {
            this.visited.clear();
        }

        @Override
        protected Boolean getDefault(Shape shape) {
            return true;
        }

        @Override
        public Boolean structureShape(StructureShape shape) {
            if (shape.members().isEmpty()) {
                return true;
            }
            for (MemberShape member : shape.members()) {
                if (member.isRequired()) continue;
                return true;
            }
            for (MemberShape member : shape.members()) {
                if (!member.isRequired() || !this.memberShape(member).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean unionShape(UnionShape shape) {
            for (MemberShape member : shape.members()) {
                if (!this.memberShape(member).booleanValue()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean memberShape(MemberShape shape) {
            return this.visited.add(shape) ? this.model.expectShape(shape.getTarget()).accept(this) : Boolean.valueOf(false);
        }
    }
}

