/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import software.amazon.smithy.utils.Pair;

final class IdentityClassCache<K, V> {
    private final ConcurrentMap<K, Pair<Type, V>> cache = new ConcurrentHashMap<K, Pair<Type, V>>();

    IdentityClassCache() {
    }

    V getForClass(K forKey, Type forClass, Supplier<? extends V> supplierIfNotPresent) {
        return (V)this.cache.compute(forKey, (key, current) -> {
            if (current == null || current.getLeft() != forClass) {
                return Pair.of((Object)forClass, supplierIfNotPresent.get());
            }
            return current;
        }).getRight();
    }
}

