/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.Deque;
import java.util.List;
import java.util.Objects;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;

public final class TextInstance {
    private final TextLocationType locationType;
    private final String text;
    private final Shape shape;
    private final Trait trait;
    private final List<String> traitPropertyPath;

    private TextInstance(TextLocationType locationType, String text, Shape shape, Trait trait, Deque<String> traitPropertyPath) {
        this.locationType = locationType;
        this.text = text;
        this.shape = shape;
        this.trait = trait;
        this.traitPropertyPath = traitPropertyPath != null ? ListUtils.copyOf(traitPropertyPath) : ListUtils.of();
    }

    static TextInstance createNamespaceText(String namespace) {
        Objects.requireNonNull(namespace, "'namespace' must be specified");
        return new TextInstance(TextLocationType.NAMESPACE, namespace, null, null, null);
    }

    static TextInstance createShapeInstance(Shape shape) {
        Objects.requireNonNull(shape, "'shape' must be specified");
        return new TextInstance(TextLocationType.SHAPE, shape.getId().getMember().orElseGet(() -> shape.getId().getName()), shape, null, null);
    }

    static TextInstance createTraitInstance(String text, Shape shape, Trait trait, Deque<String> traitPath) {
        Objects.requireNonNull(trait, "'trait' must be specified");
        Objects.requireNonNull(shape, "'shape' must be specified");
        Objects.requireNonNull(text, "'text' must be specified");
        return new TextInstance(TextLocationType.APPLIED_TRAIT, text, shape, trait, traitPath);
    }

    public TextLocationType getLocationType() {
        return this.locationType;
    }

    public String getText() {
        return this.text;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Trait getTrait() {
        return this.trait;
    }

    public List<String> getTraitPropertyPath() {
        return this.traitPropertyPath;
    }

    public static enum TextLocationType {
        SHAPE,
        APPLIED_TRAIT,
        NAMESPACE;

    }
}

