/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NullableIndex;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.AddedDefaultTrait;
import software.amazon.smithy.model.traits.ClientOptionalTrait;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.NotPropertyTrait;
import software.amazon.smithy.model.traits.PropertyTrait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class DowngradeToV1 {
    DowngradeToV1() {
    }

    Model transform(ModelTransformer transformer, Model model) {
        model = transformer.flattenAndRemoveMixins(model);
        model = this.downgradeEnums(transformer, model);
        model = this.removeResourceProperties(transformer, model);
        model = this.removeUnnecessaryDefaults(transformer, model);
        return this.removeOtherV2Traits(transformer, model);
    }

    private Model downgradeEnums(ModelTransformer transformer, Model model) {
        HashMap<ShapeId, ShapeType> typeChanges = new HashMap<ShapeId, ShapeType>();
        for (Shape shape : model.getEnumShapes()) {
            typeChanges.put(shape.getId(), ShapeType.STRING);
        }
        for (Shape shape : model.getIntEnumShapes()) {
            typeChanges.put(shape.getId(), ShapeType.INTEGER);
        }
        return transformer.changeShapeType(model, typeChanges);
    }

    private Model removeResourceProperties(ModelTransformer transformer, Model model) {
        ArrayList<Shape> updates = new ArrayList<Shape>();
        for (ResourceShape resourceShape : model.getResourceShapes()) {
            if (!resourceShape.hasProperties()) continue;
            updates.add(resourceShape.toBuilder().properties(Collections.emptyMap()).build());
        }
        for (Shape shape : model.getShapesWithTrait(NotPropertyTrait.class)) {
            updates.add((Shape)((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).removeTrait(NotPropertyTrait.ID).build());
        }
        for (Shape shape : model.getShapesWithTrait(PropertyTrait.class)) {
            updates.add((Shape)((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).removeTrait(PropertyTrait.ID).build());
        }
        return transformer.replaceShapes(model, updates);
    }

    private Model removeUnnecessaryDefaults(ModelTransformer transformer, Model model) {
        HashSet<Shape> updates = new HashSet<Shape>();
        for (MemberShape memberShape : model.getMemberShapesWithTrait(AddedDefaultTrait.class)) {
            updates.add(((MemberShape.Builder)((MemberShape.Builder)memberShape.toBuilder().removeTrait(DefaultTrait.ID)).removeTrait(AddedDefaultTrait.ID)).build());
        }
        for (Shape shape : model.getShapesWithTrait(DefaultTrait.class)) {
            if (!this.removeDefaultFromShape(shape, model)) continue;
            updates.add((Shape)((AbstractShapeBuilder)((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).removeTrait(DefaultTrait.ID)).removeTrait(AddedDefaultTrait.ID).build());
        }
        return transformer.replaceShapes(model, updates);
    }

    private boolean removeDefaultFromShape(Shape shape, Model model) {
        DefaultTrait trait = shape.expectTrait(DefaultTrait.class);
        if (trait.toNode().isNullNode()) {
            return false;
        }
        Shape target = model.expectShape(shape.asMemberShape().map(MemberShape::getTarget).orElse(shape.getId()));
        DefaultTrait targetDefault = target.getTrait(DefaultTrait.class).orElse(null);
        if (targetDefault == null || !targetDefault.toNode().equals(trait.toNode())) {
            return true;
        }
        return !NullableIndex.isDefaultZeroValueOfTypeInV1(trait.toNode(), target.getType());
    }

    private Model removeOtherV2Traits(ModelTransformer transformer, Model model) {
        HashSet<MemberShape> updates = new HashSet<MemberShape>();
        for (StructureShape structure : model.getStructureShapes()) {
            for (MemberShape member : structure.getAllMembers().values()) {
                if (!member.hasTrait(ClientOptionalTrait.ID)) continue;
                updates.add(((MemberShape.Builder)member.toBuilder().removeTrait(ClientOptionalTrait.ID)).build());
            }
        }
        return transformer.replaceShapes(model, updates);
    }
}

