/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeType;
import software.amazon.smithy.model.node.NodeVisitor;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIdSyntaxException;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyInternalApi;

public final class StringNode
extends Node
implements Comparable<StringNode> {
    private String value;

    public StringNode(String value, SourceLocation sourceLocation) {
        super(sourceLocation);
        this.value = Objects.requireNonNull(value);
    }

    @SmithyInternalApi
    public static Pair<StringNode, Consumer<String>> createLazyString(String placeholder, SourceLocation sourceLocation) {
        StringNode result = new StringNode(placeholder, sourceLocation);
        return Pair.of((Object)result, result::updateValue);
    }

    @Override
    public NodeType getType() {
        return NodeType.STRING;
    }

    @Override
    public <R> R accept(NodeVisitor<R> visitor) {
        return visitor.stringNode(this);
    }

    @Override
    public StringNode expectStringNode(String errorMessage) {
        return this;
    }

    @Override
    public StringNode expectStringNode(Supplier<String> errorMessage) {
        return this;
    }

    @Override
    public Optional<StringNode> asStringNode() {
        return Optional.of(this);
    }

    public String getValue() {
        return this.value;
    }

    private void updateValue(String value) {
        this.value = Objects.requireNonNull(value, "String value cannot be null");
    }

    public String expectOneOf(String ... validValues) {
        return this.expectOneOf(Arrays.asList(validValues));
    }

    public String expectOneOf(Collection<String> validValues) {
        if (!validValues.contains(this.value)) {
            throw new ExpectationNotMetException(String.format("Expected one of %s; got `%s`.", ValidationUtils.tickedList(validValues), this.value), this);
        }
        return this.value;
    }

    public ShapeId expectShapeId(String namespace) {
        try {
            return ShapeId.fromOptionalNamespace(namespace, this.getValue());
        }
        catch (ShapeIdSyntaxException e) {
            throw new SourceException(e.getMessage(), this);
        }
    }

    public ShapeId expectShapeId() {
        try {
            return ShapeId.from(this.getValue());
        }
        catch (ShapeIdSyntaxException e) {
            throw new SourceException(e.getMessage(), this);
        }
    }

    public Optional<ShapeId> asShapeId() {
        try {
            return Optional.of(ShapeId.from(this.getValue()));
        }
        catch (ShapeIdSyntaxException e) {
            return Optional.empty();
        }
    }

    public boolean equals(Object other) {
        return other instanceof StringNode && this.value.equals(((StringNode)other).getValue());
    }

    public int hashCode() {
        return this.getType().hashCode() * 7 + this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(StringNode o) {
        return this.getValue().compareTo(o.getValue());
    }
}

