/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.function.Consumer;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.IdlInternalTokenizer;
import software.amazon.smithy.model.loader.IdlModelLoader;
import software.amazon.smithy.model.loader.IdlShapeIdParser;
import software.amazon.smithy.model.loader.IdlToken;
import software.amazon.smithy.model.loader.ModelSyntaxException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NullNode;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;

final class IdlNodeParser {
    private static final String SYNTACTIC_SHAPE_ID_TARGET = "SyntacticShapeIdTarget";

    private IdlNodeParser() {
    }

    static Node expectAndSkipNode(IdlModelLoader loader) {
        return IdlNodeParser.expectAndSkipNode(loader, loader.getTokenizer().getCurrentTokenLocation());
    }

    static Node expectAndSkipNode(IdlModelLoader loader, SourceLocation location) {
        IdlInternalTokenizer tokenizer = loader.getTokenizer();
        IdlToken token = tokenizer.expect(IdlToken.STRING, IdlToken.TEXT_BLOCK, IdlToken.NUMBER, IdlToken.IDENTIFIER, IdlToken.LBRACE, IdlToken.LBRACKET);
        switch (token) {
            case STRING: 
            case TEXT_BLOCK: {
                StringNode result = new StringNode(tokenizer.getCurrentTokenStringSlice().toString(), location);
                tokenizer.next();
                return result;
            }
            case IDENTIFIER: {
                String shapeId = loader.internString(IdlShapeIdParser.expectAndSkipShapeId(tokenizer));
                return IdlNodeParser.createIdentifier(loader, shapeId, location);
            }
            case NUMBER: {
                Number number = tokenizer.getCurrentTokenNumberValue();
                tokenizer.next();
                return new NumberNode(number, location);
            }
            case LBRACE: {
                return IdlNodeParser.parseObjectNode(loader, location);
            }
        }
        return IdlNodeParser.parseArrayNode(loader, location);
    }

    static Node createIdentifier(IdlModelLoader loader, String identifier, SourceLocation location) {
        Keyword keyword = Keyword.from(identifier);
        return keyword == null ? IdlNodeParser.createSyntacticShapeId(loader, identifier, location) : keyword.createNode(location);
    }

    private static Node createSyntacticShapeId(IdlModelLoader loader, String identifier, SourceLocation location) {
        Pair<StringNode, Consumer<String>> pair = StringNode.createLazyString(identifier, location);
        Consumer consumer = (Consumer)pair.right;
        loader.addForwardReference(identifier, (id, type) -> {
            consumer.accept(id.toString());
            if (type != null) {
                return null;
            }
            return ValidationEvent.builder().id(SYNTACTIC_SHAPE_ID_TARGET).severity(Severity.DANGER).message(String.format("Syntactic shape ID `%s` does not resolve to a valid shape ID: `%s`. Did you mean to quote this string? Are you missing a model file?", identifier, id)).sourceLocation(location).build();
        });
        return (Node)pair.left;
    }

    private static ArrayNode parseArrayNode(IdlModelLoader loader, SourceLocation location) {
        loader.increaseNestingLevel();
        ArrayNode.Builder builder = ArrayNode.builder().sourceLocation(location);
        IdlInternalTokenizer tokenizer = loader.getTokenizer();
        tokenizer.expect(IdlToken.LBRACKET);
        tokenizer.next();
        tokenizer.skipWsAndDocs();
        while (tokenizer.getCurrentToken() != IdlToken.RBRACKET) {
            builder.withValue(IdlNodeParser.expectAndSkipNode(loader));
            tokenizer.skipWsAndDocs();
        }
        tokenizer.expect(IdlToken.RBRACKET);
        tokenizer.next();
        loader.decreaseNestingLevel();
        return builder.build();
    }

    private static ObjectNode parseObjectNode(IdlModelLoader loader, SourceLocation location) {
        IdlInternalTokenizer tokenizer = loader.getTokenizer();
        tokenizer.expect(IdlToken.LBRACE);
        tokenizer.next();
        tokenizer.skipWsAndDocs();
        loader.increaseNestingLevel();
        ObjectNode.Builder builder = ObjectNode.builder().sourceLocation(location);
        while (tokenizer.hasNext() && tokenizer.expect(IdlToken.RBRACE, IdlToken.STRING, IdlToken.IDENTIFIER) != IdlToken.RBRACE) {
            String key = loader.internString(tokenizer.getCurrentTokenStringSlice());
            SourceLocation keyLocation = tokenizer.getCurrentTokenLocation();
            tokenizer.next();
            tokenizer.skipWsAndDocs();
            tokenizer.expect(IdlToken.COLON);
            tokenizer.next();
            tokenizer.skipWsAndDocs();
            Node value = IdlNodeParser.expectAndSkipNode(loader);
            if (builder.hasMember(key)) {
                throw new ModelSyntaxException("Duplicate member: '" + key + '\'', keyLocation);
            }
            builder.withMember(key, value);
            tokenizer.skipWsAndDocs();
        }
        tokenizer.expect(IdlToken.RBRACE);
        tokenizer.next();
        loader.decreaseNestingLevel();
        return builder.build();
    }

    private static enum Keyword {
        TRUE{

            @Override
            protected Node createNode(SourceLocation location) {
                return new BooleanNode(true, location);
            }
        }
        ,
        FALSE{

            @Override
            protected Node createNode(SourceLocation location) {
                return new BooleanNode(false, location);
            }
        }
        ,
        NULL{

            @Override
            protected Node createNode(SourceLocation location) {
                return new NullNode(location);
            }
        };


        protected abstract Node createNode(SourceLocation var1);

        static Keyword from(String keyword) {
            switch (keyword) {
                case "true": {
                    return TRUE;
                }
                case "false": {
                    return FALSE;
                }
                case "null": {
                    return NULL;
                }
            }
            return null;
        }
    }
}

