/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.utils.SetUtils;

public final class HttpHeaderTraitValidator
extends AbstractValidator {
    private static final Set<Character> TCHAR = SetUtils.of((Object[])new Character[]{Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('.'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('|'), Character.valueOf('~'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')});
    private static final Set<String> BLOCKLIST = SetUtils.of((Object[])new String[]{"authorization", "connection", "content-length", "expect", "host", "max-forwards", "proxy-authenticate", "server", "te", "trailer", "transfer-encoding", "upgrade", "user-agent", "www-authenticate", "x-forwarded-for"});

    @Override
    public List<ValidationEvent> validate(Model model) {
        if (!model.isTraitApplied(HttpHeaderTrait.class)) {
            return Collections.emptyList();
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (StructureShape structure : model.getStructureShapes()) {
            events.addAll(this.validateStructure(structure));
        }
        for (MemberShape member : model.getMemberShapesWithTrait(HttpHeaderTrait.class)) {
            HttpHeaderTrait httpHeaderTrait = member.expectTrait(HttpHeaderTrait.class);
            this.validateHeader(member, httpHeaderTrait).ifPresent(events::add);
        }
        return events;
    }

    private Optional<ValidationEvent> validateHeader(MemberShape member, HttpHeaderTrait trait) {
        String header = trait.getValue();
        if (BLOCKLIST.contains(header.toLowerCase(Locale.ENGLISH))) {
            return Optional.of(this.danger((Shape)member, trait, String.format("`%s` is not an allowed HTTP header binding", header)));
        }
        for (int i = 0; i < header.length(); ++i) {
            if (TCHAR.contains(Character.valueOf(header.charAt(i)))) continue;
            return Optional.of(this.danger((Shape)member, trait, String.format("`%s` is not a valid HTTP header field name according to section 5.6.2 of RFC 9110", header)));
        }
        return Optional.empty();
    }

    private List<ValidationEvent> validateStructure(StructureShape structure) {
        return structure.getAllMembers().values().stream().filter(member -> member.hasTrait(HttpHeaderTrait.ID)).collect(Collectors.groupingBy(shape -> shape.expectTrait(HttpHeaderTrait.class).getValue().toLowerCase(Locale.US), Collectors.mapping(MemberShape::getMemberName, Collectors.toList()))).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> this.error(structure, String.format("`httpHeader` field name binding conflicts found for the `%s` header in the following structure members: %s", entry.getKey(), ValidationUtils.tickedList((Collection)entry.getValue())))).collect(Collectors.toList());
    }
}

