/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.math.BigDecimal;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.RangeTrait;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.node.NodeValidatorPlugin;

class RangeTraitPlugin
implements NodeValidatorPlugin {
    private static final String MEMBER = "Member";
    private static final String TARGET = "Target";
    private static final String INVALID_RANGE = "InvalidRange";

    RangeTraitPlugin() {
    }

    @Override
    public final void apply(Shape shape, Node value, NodeValidatorPlugin.Context context, NodeValidatorPlugin.Emitter emitter) {
        if (shape.hasTrait(RangeTrait.ID)) {
            if (value.isNumberNode()) {
                this.check(shape, context, shape.expectTrait(RangeTrait.class), value.expectNumberNode(), emitter);
            } else if (value.isStringNode()) {
                this.checkNonNumeric(shape, shape.expectTrait(RangeTrait.class), value.expectStringNode(), emitter, context);
            }
        }
    }

    private void checkNonNumeric(Shape shape, RangeTrait trait, StringNode node, NodeValidatorPlugin.Emitter emitter, NodeValidatorPlugin.Context context) {
        Node.NonNumericFloat.fromStringRepresentation(node.getValue()).ifPresent(value -> {
            if (value.equals((Object)Node.NonNumericFloat.NAN)) {
                emitter.accept(node, this.getSeverity(context), String.format("Value provided for `%s` must be a number because the `smithy.api#range` trait is applied, but found \"%s\"", shape.getId(), node.getValue()));
            }
            if (trait.getMin().isPresent() && value.equals((Object)Node.NonNumericFloat.NEGATIVE_INFINITY)) {
                emitter.accept(node, this.getSeverity(context), String.format("Value provided for `%s` must be greater than or equal to %s, but found \"%s\"", shape.getId(), trait.getMin().get(), node.getValue()), shape.isMemberShape() ? MEMBER : TARGET, INVALID_RANGE);
            }
            if (trait.getMax().isPresent() && value.equals((Object)Node.NonNumericFloat.POSITIVE_INFINITY)) {
                emitter.accept(node, this.getSeverity(context), String.format("Value provided for `%s` must be less than or equal to %s, but found \"%s\"", shape.getId(), trait.getMax().get(), node.getValue()), shape.isMemberShape() ? MEMBER : TARGET, INVALID_RANGE);
            }
        });
    }

    protected void check(Shape shape, NodeValidatorPlugin.Context context, RangeTrait trait, NumberNode node, NodeValidatorPlugin.Emitter emitter) {
        trait.getMin().ifPresent(min -> node.asBigDecimal().ifPresent(decimal -> {
            if (decimal.compareTo((BigDecimal)min) < 0) {
                emitter.accept(node, this.getSeverity(node, context), String.format("Value provided for `%s` must be greater than or equal to %s, but found %s", shape.getId(), min, decimal), shape.isMemberShape() ? MEMBER : TARGET, INVALID_RANGE);
            }
        }));
        trait.getMax().ifPresent(max -> node.asBigDecimal().ifPresent(decimal -> {
            if (decimal.compareTo((BigDecimal)max) > 0) {
                emitter.accept(node, this.getSeverity(node, context), String.format("Value provided for `%s` must be less than or equal to %s, but found %s", shape.getId(), max, decimal), shape.isMemberShape() ? MEMBER : TARGET, INVALID_RANGE);
            }
        }));
    }

    private Severity getSeverity(NumberNode node, NodeValidatorPlugin.Context context) {
        boolean zeroValueWarning = context.hasFeature(NodeValidationVisitor.Feature.RANGE_TRAIT_ZERO_VALUE_WARNING);
        boolean rangeTraitWarning = context.hasFeature(NodeValidationVisitor.Feature.ALLOW_CONSTRAINT_ERRORS);
        return zeroValueWarning && node.isZero() || rangeTraitWarning ? Severity.WARNING : Severity.ERROR;
    }

    private Severity getSeverity(NodeValidatorPlugin.Context context) {
        return context.hasFeature(NodeValidationVisitor.Feature.ALLOW_CONSTRAINT_ERRORS) ? Severity.WARNING : Severity.ERROR;
    }
}

