/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.validation.ValidationEventDecorator;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.ValidatorService;

public interface ValidatorFactory {
    public List<Validator> loadBuiltinValidators();

    default public List<ValidationEventDecorator> loadDecorators() {
        return Collections.emptyList();
    }

    public Optional<Validator> createValidator(String var1, ObjectNode var2);

    public static ValidatorFactory createServiceFactory(Iterable<Validator> validators, Iterable<ValidatorService> services) {
        final ArrayList serviceList = new ArrayList();
        services.forEach(serviceList::add);
        final ArrayList validatorsList = new ArrayList();
        validators.forEach(validatorsList::add);
        return new ValidatorFactory(){

            @Override
            public List<Validator> loadBuiltinValidators() {
                return Collections.unmodifiableList(validatorsList);
            }

            @Override
            public Optional<Validator> createValidator(String name, ObjectNode configuration) {
                return serviceList.stream().filter(service -> service.getName().equals(name)).map(service -> service.createValidator(configuration)).findFirst();
            }
        };
    }

    public static ValidatorFactory createServiceFactory(Iterable<Validator> validators, Iterable<ValidatorService> services, Iterable<ValidationEventDecorator> decorators) {
        final ArrayList serviceList = new ArrayList();
        services.forEach(serviceList::add);
        final ArrayList validatorsList = new ArrayList();
        validators.forEach(validatorsList::add);
        final ArrayList decoratorsList = new ArrayList();
        decorators.forEach(decoratorsList::add);
        return new ValidatorFactory(){

            @Override
            public List<Validator> loadBuiltinValidators() {
                return Collections.unmodifiableList(validatorsList);
            }

            @Override
            public List<ValidationEventDecorator> loadDecorators() {
                return Collections.unmodifiableList(decoratorsList);
            }

            @Override
            public Optional<Validator> createValidator(String name, ObjectNode configuration) {
                return serviceList.stream().filter(service -> service.getName().equals(name)).map(service -> service.createValidator(configuration)).findFirst();
            }
        };
    }

    public static ValidatorFactory createServiceFactory(ClassLoader classLoader) {
        return ValidatorFactory.createServiceFactory(ServiceLoader.load(Validator.class, classLoader), ServiceLoader.load(ValidatorService.class, classLoader), ServiceLoader.load(ValidationEventDecorator.class, classLoader));
    }
}

