/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidatedResultException;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;

public final class ValidatedResult<T> {
    private static final ValidatedResult<?> EMPTY = new ValidatedResult<Object>(null, ListUtils.of());
    private final List<ValidationEvent> events;
    private final T result;

    public ValidatedResult(T result, List<ValidationEvent> events) {
        this.result = result;
        this.events = Collections.unmodifiableList(events);
    }

    @Deprecated
    public ValidatedResult(T result, Collection<ValidationEvent> events) {
        this(result, ListUtils.copyOf(events));
    }

    public static <T> ValidatedResult<T> fromErrors(List<ValidationEvent> events) {
        return new ValidatedResult<Object>(null, events);
    }

    @Deprecated
    public static <T> ValidatedResult<T> fromErrors(Collection<ValidationEvent> events) {
        return ValidatedResult.fromErrors(ListUtils.copyOf(events));
    }

    public static <T> ValidatedResult<T> fromValue(T value) {
        return new ValidatedResult<T>(value, ListUtils.of());
    }

    public static <T> ValidatedResult<T> empty() {
        return EMPTY;
    }

    public List<ValidationEvent> getValidationEvents() {
        return this.events;
    }

    public List<ValidationEvent> getValidationEvents(Severity severity) {
        return this.getValidationEvents().stream().filter(event -> event.getSeverity() == severity).collect(Collectors.toList());
    }

    public Optional<T> getResult() {
        return Optional.ofNullable(this.result);
    }

    public T unwrap() {
        return this.validate().orElseThrow(() -> new IllegalStateException("Validated result contains no value"));
    }

    public Optional<T> validate() {
        if (!this.isBroken()) {
            return this.getResult();
        }
        throw new ValidatedResultException(this.events);
    }

    public boolean isBroken() {
        for (ValidationEvent event : this.events) {
            if (event.getSeverity() != Severity.ERROR && event.getSeverity() != Severity.DANGER) continue;
            return true;
        }
        return false;
    }
}

