/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.MixinTrait;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ResourceShape
extends EntityShape
implements ToSmithyBuilder<ResourceShape> {
    private final Map<String, ShapeId> identifiers;
    private final Map<String, ShapeId> properties;
    private final ShapeId put;
    private final ShapeId create;
    private final ShapeId read;
    private final ShapeId update;
    private final ShapeId delete;
    private final ShapeId list;
    private final Set<ShapeId> collectionOperations;
    private final Set<ShapeId> allOperations = new HashSet<ShapeId>();

    private ResourceShape(Builder builder) {
        super(builder);
        this.identifiers = (Map)builder.identifiers.copy();
        this.properties = (Map)builder.properties.copy();
        this.put = builder.put;
        this.create = builder.create;
        this.read = builder.read;
        this.update = builder.update;
        this.delete = builder.delete;
        this.list = builder.list;
        this.collectionOperations = (Set)builder.collectionOperations.copy();
        this.allOperations.addAll(this.getOperations());
        this.allOperations.addAll(this.getCollectionOperations());
        this.getPut().ifPresent(this.allOperations::add);
        this.getCreate().ifPresent(this.allOperations::add);
        this.getRead().ifPresent(this.allOperations::add);
        this.getUpdate().ifPresent(this.allOperations::add);
        this.getDelete().ifPresent(this.allOperations::add);
        this.getList().ifPresent(this.allOperations::add);
        if (this.hasTrait(MixinTrait.ID) && (!this.getIdentifiers().isEmpty() || this.getPut().isPresent() || this.getCreate().isPresent() || this.getRead().isPresent() || this.getUpdate().isPresent() || this.getDelete().isPresent() || this.getList().isPresent() || !this.getProperties().isEmpty() || !this.getOperations().isEmpty() || !this.getResources().isEmpty())) {
            throw new IllegalStateException(String.format("Resource shapes with the mixin trait may not define any properties. Resource mixin shape `%s` defines one or more properties.", this.getId()));
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = this.updateBuilder(ResourceShape.builder()).identifiers(this.getIdentifiers()).properties(this.properties).put(this.put).create(this.create).read(this.read).update(this.update).delete(this.delete).list(this.list);
        this.getOperations().forEach(builder::addOperation);
        this.getCollectionOperations().forEach(builder::addCollectionOperation);
        this.getResources().forEach(builder::addResource);
        return builder;
    }

    @Override
    public <R> R accept(ShapeVisitor<R> visitor) {
        return visitor.resourceShape(this);
    }

    @Override
    public Optional<ResourceShape> asResourceShape() {
        return Optional.of(this);
    }

    @Override
    public Set<ShapeId> getAllOperations() {
        return Collections.unmodifiableSet(this.allOperations);
    }

    @Override
    public ShapeType getType() {
        return ShapeType.RESOURCE;
    }

    public Set<ShapeId> getCollectionOperations() {
        return Collections.unmodifiableSet(this.collectionOperations);
    }

    public Map<String, ShapeId> getIdentifiers() {
        return this.identifiers;
    }

    public boolean hasIdentifiers() {
        return !this.identifiers.isEmpty();
    }

    public Map<String, ShapeId> getProperties() {
        return this.properties;
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    public Optional<ShapeId> getPut() {
        return Optional.ofNullable(this.put);
    }

    public Optional<ShapeId> getCreate() {
        return Optional.ofNullable(this.create);
    }

    public Optional<ShapeId> getRead() {
        return Optional.ofNullable(this.read);
    }

    public Optional<ShapeId> getUpdate() {
        return Optional.ofNullable(this.update);
    }

    public Optional<ShapeId> getDelete() {
        return Optional.ofNullable(this.delete);
    }

    public Optional<ShapeId> getList() {
        return Optional.ofNullable(this.list);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        ResourceShape otherShape = (ResourceShape)other;
        return this.identifiers.equals(otherShape.identifiers) && Objects.equals(this.properties, otherShape.properties) && Objects.equals(this.create, otherShape.create) && Objects.equals(this.put, otherShape.put) && Objects.equals(this.read, otherShape.read) && Objects.equals(this.update, otherShape.update) && Objects.equals(this.delete, otherShape.delete) && Objects.equals(this.list, otherShape.list);
    }

    public static final class Builder
    extends EntityShape.Builder<Builder, ResourceShape> {
        private final BuilderRef<Map<String, ShapeId>> identifiers = BuilderRef.forOrderedMap();
        private final BuilderRef<Map<String, ShapeId>> properties = BuilderRef.forOrderedMap();
        private final BuilderRef<Set<ShapeId>> collectionOperations = BuilderRef.forOrderedSet();
        private ShapeId put;
        private ShapeId create;
        private ShapeId read;
        private ShapeId update;
        private ShapeId delete;
        private ShapeId list;

        public ResourceShape build() {
            return new ResourceShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.RESOURCE;
        }

        public Builder identifiers(Map<String, ShapeId> identifiers) {
            this.identifiers.clear();
            ((Map)this.identifiers.get()).putAll(identifiers);
            return this;
        }

        public Builder addIdentifier(String name, ToShapeId identifier) {
            ((Map)this.identifiers.get()).put(Objects.requireNonNull(name), identifier.toShapeId());
            return this;
        }

        public Builder addIdentifier(String name, String identifier) {
            return this.addIdentifier(name, ShapeId.from(identifier));
        }

        public Builder properties(Map<String, ShapeId> properties) {
            this.properties.clear();
            ((Map)this.properties.get()).putAll(properties);
            return this;
        }

        public Builder addProperty(String name, ToShapeId targetShape) {
            ((Map)this.properties.get()).put(Objects.requireNonNull(name), targetShape.toShapeId());
            return this;
        }

        public Builder addProperty(String name, String targetShape) {
            return this.addProperty(name, ShapeId.from(targetShape));
        }

        public Builder put(ToShapeId put) {
            this.put = put == null ? null : put.toShapeId();
            return this;
        }

        public Builder create(ToShapeId create) {
            this.create = create == null ? null : create.toShapeId();
            return this;
        }

        public Builder read(ToShapeId read) {
            this.read = read == null ? null : read.toShapeId();
            return this;
        }

        public Builder update(ToShapeId update) {
            this.update = update == null ? null : update.toShapeId();
            return this;
        }

        public Builder delete(ToShapeId delete) {
            this.delete = delete == null ? null : delete.toShapeId();
            return this;
        }

        public Builder list(ToShapeId list) {
            this.list = list == null ? null : list.toShapeId();
            return this;
        }

        public Builder collectionOperations(Collection<ShapeId> ids) {
            this.clearCollectionOperations();
            ((Set)this.collectionOperations.get()).addAll(ids);
            return this;
        }

        public Builder addCollectionOperation(ToShapeId id) {
            ((Set)this.collectionOperations.get()).add(id.toShapeId());
            return this;
        }

        public Builder addCollectionOperation(String id) {
            return this.addCollectionOperation(ShapeId.from(id));
        }

        public Builder removeCollectionOperation(ToShapeId id) {
            ((Set)this.collectionOperations.get()).remove(id.toShapeId());
            return this;
        }

        public Builder clearCollectionOperations() {
            this.collectionOperations.clear();
            return this;
        }

        public Builder removeFromAllOperationBindings(ToShapeId toShapeId) {
            ShapeId id = toShapeId.toShapeId();
            this.removeOperation(id);
            this.removeCollectionOperation(id);
            if (Objects.equals(this.create, id)) {
                this.create = null;
            }
            if (Objects.equals(this.put, id)) {
                this.put = null;
            }
            if (Objects.equals(this.read, id)) {
                this.read = null;
            }
            if (Objects.equals(this.update, id)) {
                this.update = null;
            }
            if (Objects.equals(this.delete, id)) {
                this.delete = null;
            }
            if (Objects.equals(this.list, id)) {
                this.list = null;
            }
            return this;
        }
    }
}

