/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;

final class RecursiveSelector
implements InternalSelector {
    private final InternalSelector selector;

    RecursiveSelector(InternalSelector selector) {
        this.selector = selector;
    }

    @Override
    public InternalSelector.Response push(Context context, Shape shape, InternalSelector.Receiver next) {
        QueueReceiver queueReceiver = new QueueReceiver(next);
        queueReceiver.queue.add(shape);
        while (!queueReceiver.queue.isEmpty()) {
            Shape match = queueReceiver.queue.pop();
            if (this.selector.push(context, match, queueReceiver) != InternalSelector.Response.STOP) continue;
            return InternalSelector.Response.STOP;
        }
        return InternalSelector.Response.CONTINUE;
    }

    private static final class QueueReceiver
    implements InternalSelector.Receiver {
        final Deque<Shape> queue = new ArrayDeque<Shape>();
        private final Set<ShapeId> visited = new HashSet<ShapeId>();
        private final InternalSelector.Receiver next;

        QueueReceiver(InternalSelector.Receiver next) {
            this.next = next;
        }

        @Override
        public InternalSelector.Response apply(Context context, Shape matchedShapeFromSelector) {
            if (this.visited.add(matchedShapeFromSelector.getId())) {
                if (this.next.apply(context, matchedShapeFromSelector) == InternalSelector.Response.STOP) {
                    return InternalSelector.Response.STOP;
                }
                this.queue.add(matchedShapeFromSelector);
            }
            return InternalSelector.Response.CONTINUE;
        }
    }
}

