/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import software.amazon.smithy.model.loader.DefaultTokenizer;
import software.amazon.smithy.model.loader.IdlToken;
import software.amazon.smithy.model.loader.LoaderUtils;
import software.amazon.smithy.model.validation.ValidationEvent;

final class IdlInternalTokenizer
extends DefaultTokenizer {
    private final CharSequence model;
    private final Deque<CharSequence> docCommentLines = new ArrayDeque<CharSequence>();
    private final Consumer<ValidationEvent> validationEventListener;

    IdlInternalTokenizer(String filename, CharSequence model) {
        this(filename, model, event -> {});
    }

    IdlInternalTokenizer(String filename, CharSequence model, Consumer<ValidationEvent> validationEventListener) {
        super(filename, model);
        this.model = model;
        this.validationEventListener = validationEventListener;
    }

    @Override
    public IdlToken next() {
        IdlToken token = super.next();
        if (token == IdlToken.DOC_COMMENT) {
            int start = this.getCurrentTokenStart();
            int span = this.getCurrentTokenSpan();
            int docStart = span <= 3 ? start : (this.model.charAt(start + 3) == ' ' ? start + 4 : start + 3);
            int end = this.getCurrentTokenEnd();
            if (this.model.charAt(end - 1) == '\n' && --end >= 0 && this.model.charAt(end - 1) == '\r') {
                --end;
            }
            this.docCommentLines.add(this.getModel(docStart, end));
        }
        return token;
    }

    void skipSpaces() {
        while (this.getCurrentToken() == IdlToken.SPACE) {
            this.next();
        }
    }

    void skipOptionalComma() {
        if (this.getCurrentToken() == IdlToken.COMMA) {
            this.next();
        }
    }

    void skipWs() {
        while (this.getCurrentToken().isWhitespace()) {
            this.next();
        }
    }

    void skipWsAndDocs() {
        IdlToken currentTokenType = this.getCurrentToken();
        while (currentTokenType.isWhitespace() || currentTokenType == IdlToken.DOC_COMMENT) {
            this.next();
            currentTokenType = this.getCurrentToken();
        }
    }

    void expectAndSkipSpaces() {
        this.expect(IdlToken.SPACE);
        this.skipSpaces();
    }

    void expectAndSkipWhitespace() {
        if (!this.getCurrentToken().isWhitespace()) {
            throw LoaderUtils.idlSyntaxError("Expected one or more whitespace characters, but found " + this.getCurrentToken().getDebug(this.getCurrentTokenLexeme()), this.getCurrentTokenLocation());
        }
        this.skipWsAndDocs();
    }

    void expectAndSkipBr() {
        this.skipSpaces();
        this.clearDocCommentLinesForBr();
        switch (this.getCurrentToken()) {
            case NEWLINE: 
            case COMMENT: 
            case DOC_COMMENT: {
                this.next();
                this.skipWs();
                break;
            }
            case EOF: {
                break;
            }
            default: {
                throw LoaderUtils.idlSyntaxError("Expected a line break, but found " + this.getCurrentToken().getDebug(this.getCurrentTokenLexeme()), this.getCurrentTokenLocation());
            }
        }
    }

    void clearDocCommentLinesForBr() {
        if (!this.docCommentLines.isEmpty()) {
            this.validationEventListener.accept(LoaderUtils.emitBadDocComment(this.getCurrentTokenLocation(), this.removePendingDocCommentLines()));
        }
    }

    String removePendingDocCommentLines() {
        if (this.docCommentLines.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        while (!this.docCommentLines.isEmpty()) {
            result.append(this.docCommentLines.removeFirst()).append("\n");
        }
        result.setLength(result.length() - 1);
        return result.toString();
    }
}

