/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.loader.ShapeModifier;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;

final class ApplyMixin
implements ShapeModifier {
    private final ShapeId mixin;
    private List<ValidationEvent> events;
    private Map<ShapeId, Map<ShapeId, Trait>> potentiallyIntroducedTraits;

    ApplyMixin(ShapeId mixin) {
        this.mixin = mixin;
    }

    @Override
    public void modifyMember(AbstractShapeBuilder<?, ?> shapeBuilder, MemberShape.Builder memberBuilder, Function<ShapeId, Map<ShapeId, Trait>> unclaimedTraits, Function<ShapeId, Shape> shapeMap) {
        if (memberBuilder.getTarget() != null) {
            return;
        }
        Shape mixinShape = shapeMap.apply(this.mixin);
        if (mixinShape == null) {
            throw new SourceException("Cannot apply mixin to " + memberBuilder.getId() + ": " + this.mixin + " not found", memberBuilder);
        }
        String name = memberBuilder.getId().getMember().get();
        mixinShape.getMember(name).ifPresent(mixinMember -> memberBuilder.target(mixinMember.getTarget()));
    }

    @Override
    public void modifyShape(AbstractShapeBuilder<?, ?> builder, Map<String, MemberShape.Builder> memberBuilders, Function<ShapeId, Map<ShapeId, Trait>> unclaimedTraits, Function<ShapeId, Shape> shapeMap) {
        Shape mixinShape = shapeMap.apply(this.mixin);
        if (mixinShape == null) {
            throw new SourceException("Cannot apply mixin to " + builder.getId() + ": " + this.mixin + " not found", builder);
        }
        for (MemberShape member : mixinShape.members()) {
            MemberShape previous;
            ShapeId targetId = builder.getId().withMember(member.getMemberName());
            LinkedHashMap<ShapeId, Trait> introducedTraits = new LinkedHashMap<ShapeId, Trait>(unclaimedTraits.apply(targetId));
            if (this.potentiallyIntroducedTraits != null && this.potentiallyIntroducedTraits.containsKey(targetId)) {
                introducedTraits.putAll(this.potentiallyIntroducedTraits.get(targetId));
            }
            String memberName = member.getMemberName();
            MemberShape introducedMember = null;
            Optional<MemberShape> previouslyAdded = builder.getMember(memberName);
            if (previouslyAdded.isPresent() && !(previous = previouslyAdded.get()).getMixins().isEmpty()) {
                MemberShape.Builder previouslyAddedBuilder = previous.toBuilder();
                introducedMember = ((MemberShape.Builder)previouslyAddedBuilder.addMixin(member)).build();
                if (!previous.getTarget().equals(member.getTarget())) {
                    this.mixinMemberConflict(previouslyAddedBuilder, member);
                }
            }
            if (introducedMember == null) {
                if (memberBuilders.containsKey(member.getMemberName())) {
                    MemberShape.Builder original = memberBuilders.get(member.getMemberName());
                    introducedMember = ((MemberShape.Builder)original.addMixin(member)).build();
                    if (!introducedMember.getTarget().equals(member.getTarget())) {
                        this.mixinMemberConflict(original, member);
                    }
                } else if (!introducedTraits.isEmpty()) {
                    introducedMember = ((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(targetId)).target(member.getTarget()).source(member.getSourceLocation())).addTraits(introducedTraits.values())).addMixin(member)).build();
                }
            }
            if (introducedMember == null) continue;
            builder.addMember(introducedMember);
        }
        builder.addMixin(mixinShape);
    }

    private void mixinMemberConflict(MemberShape.Builder conflict, MemberShape other) {
        if (this.events == null) {
            this.events = new ArrayList<ValidationEvent>();
        }
        this.events.add(ValidationEvent.builder().severity(Severity.ERROR).id("Model").shapeId(conflict.getId()).sourceLocation(conflict.getSourceLocation()).message("Member conflicts with an inherited mixin member: `" + other.getId() + "`").build());
    }

    @Override
    public List<ValidationEvent> getEvents() {
        return this.events == null ? Collections.emptyList() : this.events;
    }

    void putPotentiallyIntroducedTrait(ShapeId target, Trait trait) {
        if (this.potentiallyIntroducedTraits == null) {
            this.potentiallyIntroducedTraits = new HashMap<ShapeId, Map<ShapeId, Trait>>();
        }
        Map shapeUnclaimedTraits = this.potentiallyIntroducedTraits.computeIfAbsent(target, id -> new LinkedHashMap());
        shapeUnclaimedTraits.put(trait.toShapeId(), trait);
    }
}

