/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.IdentifierBindingIndex;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.NestedPropertiesTrait;
import software.amazon.smithy.model.traits.NotPropertyTrait;
import software.amazon.smithy.model.traits.PropertyTrait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class PropertyBindingIndex
implements KnowledgeIndex {
    private final WeakReference<Model> model;
    private final OperationIndex operationIndex;
    private final Set<ShapeId> notPropertyMetaTraitSet;
    private final Map<ShapeId, Boolean> memberShapeDoesNotRequireProperty = new HashMap<ShapeId, Boolean>();
    private final Map<ShapeId, String> memberShapeToPropertyName = new HashMap<ShapeId, String>();
    private final Map<ShapeId, ShapeId> operationToInputPropertiesShape = new HashMap<ShapeId, ShapeId>();
    private final Map<ShapeId, ShapeId> operationToOutputPropertiesShape = new HashMap<ShapeId, ShapeId>();

    private PropertyBindingIndex(Model model) {
        this.model = new WeakReference<Model>(model);
        this.notPropertyMetaTraitSet = this.computeNotPropertyTraits();
        this.operationIndex = OperationIndex.of(model);
        IdentifierBindingIndex identifierIndex = IdentifierBindingIndex.of(model);
        for (ResourceShape resourceShape : model.getResourceShapes()) {
            Set<String> propertyNames = resourceShape.getProperties().keySet();
            for (ShapeId operationShapeId : resourceShape.getAllOperations()) {
                OperationShape operationShape = (OperationShape)model.getShape(operationShapeId).get();
                StructureShape inputPropertiesShape = this.getInputPropertiesShape(operationShape);
                this.operationToInputPropertiesShape.put(operationShapeId, inputPropertiesShape.getId());
                for (MemberShape memberShape : inputPropertiesShape.members()) {
                    if (identifierIndex.getOperationInputBindings(resourceShape, operationShape).values().contains(memberShape.getMemberName())) {
                        this.memberShapeDoesNotRequireProperty.put(memberShape.toShapeId(), true);
                    } else {
                        this.memberShapeDoesNotRequireProperty.put(memberShape.toShapeId(), this.doesNotRequireProperty(memberShape));
                    }
                    if (!this.doesMemberShapeRequireProperty(memberShape) && !propertyNames.contains(memberShape.getMemberName())) continue;
                    this.memberShapeToPropertyName.put(memberShape.getId(), this.getPropertyTraitName(memberShape).orElse(memberShape.getMemberName()));
                }
                if (!inputPropertiesShape.getId().equals(operationShape.getInputShape())) {
                    for (MemberShape memberShape : model.expectShape(operationShape.getInputShape()).members()) {
                        this.memberShapeDoesNotRequireProperty.put(memberShape.toShapeId(), true);
                    }
                }
                StructureShape outputPropertiesShape = this.getOutputPropertiesShape(operationShape);
                this.operationToOutputPropertiesShape.put(operationShapeId, outputPropertiesShape.getId());
                for (MemberShape memberShape : outputPropertiesShape.members()) {
                    if (identifierIndex.getOperationOutputBindings(resourceShape, operationShape).values().contains(memberShape.getMemberName())) {
                        this.memberShapeDoesNotRequireProperty.put(memberShape.toShapeId(), true);
                    } else {
                        this.memberShapeDoesNotRequireProperty.put(memberShape.toShapeId(), this.doesNotRequireProperty(memberShape));
                    }
                    if (!this.doesMemberShapeRequireProperty(memberShape) && !propertyNames.contains(memberShape.getMemberName())) continue;
                    this.memberShapeToPropertyName.put(memberShape.getId(), this.getPropertyTraitName(memberShape).orElse(memberShape.getMemberName()));
                }
                if (outputPropertiesShape.getId().equals(operationShape.getOutputShape())) continue;
                for (MemberShape memberShape : model.expectShape(operationShape.getOutputShape()).members()) {
                    this.memberShapeDoesNotRequireProperty.put(memberShape.toShapeId(), true);
                }
            }
        }
    }

    public static PropertyBindingIndex of(Model model) {
        return model.getKnowledge(PropertyBindingIndex.class, PropertyBindingIndex::new);
    }

    public Optional<String> getPropertyName(ShapeId memberShapeId) {
        return Optional.ofNullable(this.memberShapeToPropertyName.get(memberShapeId));
    }

    public boolean isMemberShapeProperty(MemberShape memberShape) {
        return this.memberShapeToPropertyName.containsKey(memberShape.toShapeId());
    }

    public StructureShape getOutputPropertiesShape(OperationShape operation) {
        Model model = this.getModel();
        return this.getPropertiesShape(this.operationIndex.getOutputMembers(operation).values(), model.expectShape(operation.getOutputShape(), StructureShape.class));
    }

    public StructureShape getInputPropertiesShape(OperationShape operation) {
        Model model = this.getModel();
        return this.getPropertiesShape(this.operationIndex.getInputMembers(operation).values(), model.expectShape(operation.getInputShape(), StructureShape.class));
    }

    public boolean doesMemberShapeRequireProperty(MemberShape memberShape) {
        return this.memberShapeDoesNotRequireProperty.getOrDefault(memberShape.toShapeId(), false) == false;
    }

    private Model getModel() {
        return Objects.requireNonNull((Model)this.model.get(), "The dereferenced WeakReference<Model> is null");
    }

    private Set<ShapeId> computeNotPropertyTraits() {
        Model model = this.getModel();
        return model.getShapesWithTrait(NotPropertyTrait.class).stream().filter(shape -> shape.hasTrait(TraitDefinition.ID)).map(Shape::toShapeId).collect(Collectors.toSet());
    }

    private Optional<String> getPropertyTraitName(MemberShape memberShape) {
        return memberShape.getTrait(PropertyTrait.class).flatMap(PropertyTrait::getName);
    }

    private boolean doesNotRequireProperty(MemberShape memberShape) {
        return this.notPropertyMetaTraitSet.stream().anyMatch(memberShape::hasTrait);
    }

    private StructureShape getPropertiesShape(Collection<MemberShape> members, StructureShape presumedShape) {
        Model model = this.getModel();
        for (MemberShape member : members) {
            Shape shape;
            if (!member.hasTrait(NestedPropertiesTrait.ID) || !(shape = model.expectShape(member.getTarget())).isStructureShape()) continue;
            return shape.asStructureShape().get();
        }
        return presumedShape;
    }
}

