/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.function.BiConsumer;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;

final class StringLengthPlugin
extends MemberAndShapeTraitPlugin<StringShape, StringNode, LengthTrait> {
    StringLengthPlugin() {
        super(StringShape.class, StringNode.class, LengthTrait.class);
    }

    @Override
    protected void check(Shape shape, LengthTrait trait, StringNode node, Model model, BiConsumer<FromSourceLocation, String> emitter) {
        trait.getMin().ifPresent(min -> {
            if ((long)node.getValue().length() < min) {
                emitter.accept(node, String.format("String value provided for `%s` must be >= %d characters, but the provided value is only %d characters.", shape.getId(), min, node.getValue().length()));
            }
        });
        trait.getMax().ifPresent(max -> {
            if ((long)node.getValue().length() > max) {
                emitter.accept(node, String.format("String value provided for `%s` must be <= %d characters, but the provided value is %d characters.", shape.getId(), max, node.getValue().length()));
            }
        });
    }
}

