/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;

abstract class NamedMembersShape
extends Shape {
    private final Map<String, MemberShape> members;
    private volatile List<String> memberNames;

    NamedMembersShape(Builder<?, ?> builder) {
        super(builder, false);
        assert (builder.members != null);
        this.members = MapUtils.orderedCopyOf(builder.members);
        this.members.forEach((key, value) -> {
            ShapeId expected = this.getId().withMember((String)key);
            if (!value.getId().equals(expected)) {
                throw new IllegalArgumentException(String.format("Expected the `%s` member of `%s` to have an ID of `%s` but found `%s`", key, this.getId(), expected, value.getId()));
            }
        });
    }

    public Map<String, MemberShape> getAllMembers() {
        return this.members;
    }

    public List<String> getMemberNames() {
        List names = this.memberNames;
        if (names == null) {
            this.memberNames = names = ListUtils.copyOf(this.members.keySet());
        }
        return names;
    }

    public Optional<MemberShape> getMember(String name) {
        return Optional.ofNullable(this.members.get(name));
    }

    @Override
    public Collection<MemberShape> members() {
        return this.members.values();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        NamedMembersShape b = (NamedMembersShape)other;
        return this.getMemberNames().equals(b.getMemberNames()) && this.members.equals(b.members);
    }

    static abstract class Builder<B extends Builder, S extends NamedMembersShape>
    extends AbstractShapeBuilder<B, S> {
        Map<String, MemberShape> members = new LinkedHashMap<String, MemberShape>();

        Builder() {
        }

        @Override
        public final B id(ShapeId shapeId) {
            for (MemberShape member : this.members.values()) {
                this.addMember(((MemberShape.Builder)member.toBuilder().id(shapeId.withMember(member.getMemberName()))).build());
            }
            return (B)((Builder)super.id(shapeId));
        }

        public B members(Collection<MemberShape> members) {
            this.members.clear();
            for (MemberShape member : members) {
                this.addMember(member);
            }
            return (B)this;
        }

        public B clearMembers() {
            this.members.clear();
            return (B)this;
        }

        @Override
        public B addMember(MemberShape member) {
            this.members.put(member.getMemberName(), member);
            return (B)this;
        }

        public B addMember(String memberName, ShapeId target) {
            return this.addMember(memberName, target, null);
        }

        public B addMember(String memberName, ShapeId target, Consumer<MemberShape.Builder> memberUpdater) {
            if (this.getId() == null) {
                throw new IllegalStateException("An id must be set before setting a member with a target");
            }
            MemberShape.Builder builder = (MemberShape.Builder)MemberShape.builder().target(target).id(this.getId().withMember(memberName));
            if (memberUpdater != null) {
                memberUpdater.accept(builder);
            }
            return (B)this.addMember(builder.build());
        }

        public B removeMember(String member) {
            this.members.remove(member);
            return (B)this;
        }
    }
}

