/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.NodeValidationVisitor;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.utils.ListUtils;

public final class TraitValueValidator
implements Validator {
    public static final String VALIDATE_PRELUDE = "__validatePrelude__";
    private static final String NAME = "TraitValue";

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        boolean validatePrelude = model.getMetadataProperty(VALIDATE_PRELUDE).isPresent();
        for (Shape shape : model.toSet()) {
            for (Trait trait : shape.getAllTraits().values()) {
                events.addAll(this.validateTrait(model, shape, trait, validatePrelude));
            }
        }
        return events;
    }

    private List<ValidationEvent> validateTrait(Model model, Shape targetShape, Trait trait, boolean validatePrelude) {
        ShapeId shape = trait.toShapeId();
        if (!model.getShape(shape).isPresent()) {
            return ListUtils.of();
        }
        if (!validatePrelude && Prelude.isPreludeShape(targetShape)) {
            return ListUtils.of();
        }
        Shape schema = model.getShape(shape).get();
        NodeValidationVisitor cases = NodeValidationVisitor.builder().model(model).value(trait.toNode()).eventShapeId(targetShape.getId()).eventId(NAME).startingContext("Error validating trait `" + Trait.getIdiomaticTraitName(trait) + "`").build();
        return schema.accept(cases);
    }
}

