/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.transform.ModelTransformer;

final class SortMembers {
    private final Comparator<MemberShape> comparator;

    SortMembers(Comparator<MemberShape> comparator) {
        this.comparator = comparator;
    }

    Model transform(ModelTransformer transformer, Model model) {
        HashSet<Shape> toReplace = new HashSet<Shape>();
        model.shapes(StructureShape.class).forEach(structure -> {
            if (!structure.getAllMembers().isEmpty()) {
                TreeSet<MemberShape> members = new TreeSet<MemberShape>(this.comparator);
                members.addAll(structure.getAllMembers().values());
                toReplace.add(((StructureShape.Builder)structure.toBuilder().members(members)).build());
            }
        });
        model.shapes(UnionShape.class).forEach(structure -> {
            if (!structure.getAllMembers().isEmpty()) {
                TreeSet<MemberShape> members = new TreeSet<MemberShape>(this.comparator);
                members.addAll(structure.getAllMembers().values());
                toReplace.add(((UnionShape.Builder)structure.toBuilder().members(members)).build());
            }
        });
        return transformer.replaceShapes(model, toReplace);
    }
}

