/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.EnumValueTrait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class EnumShapeValidator
extends AbstractValidator {
    private static final Pattern RECOMMENDED_NAME_PATTERN = Pattern.compile("^[A-Z]+[A-Z_0-9]*$");

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (EnumShape enumShape : model.getEnumShapes()) {
            this.validateEnumShape(events, enumShape);
        }
        for (IntEnumShape intEnumShape : model.getIntEnumShapes()) {
            this.validateIntEnumShape(events, intEnumShape);
        }
        return events;
    }

    private void validateEnumShape(List<ValidationEvent> events, EnumShape shape) {
        HashSet<String> values = new HashSet<String>();
        for (MemberShape member : shape.members()) {
            EnumValueTrait trait = member.expectTrait(EnumValueTrait.class);
            Optional<String> value = trait.getStringValue();
            if (!value.isPresent()) {
                events.add(this.error((Shape)member, member.expectTrait(EnumValueTrait.class), "enum members can only be assigned string values, but found: " + Node.printJson(trait.toNode())));
            } else {
                if (!values.add(value.get())) {
                    events.add(this.error(member, String.format("Multiple enum members found with duplicate value `%s`", value.get())));
                }
                if (value.get().equals("")) {
                    events.add(this.error(member, "enum values may not be empty."));
                }
            }
            this.validateEnumMemberName(events, member);
        }
    }

    private void validateIntEnumShape(List<ValidationEvent> events, IntEnumShape shape) {
        HashSet<Integer> values = new HashSet<Integer>();
        for (MemberShape member : shape.members()) {
            if (!member.hasTrait(EnumValueTrait.ID)) {
                events.add(this.missingIntEnumValue(member, member));
                continue;
            }
            EnumValueTrait trait = member.expectTrait(EnumValueTrait.class);
            if (!trait.getIntValue().isPresent()) {
                ValidationEvent event = this.error((Shape)member, trait, "intEnum members require integer values, but found: " + Node.printJson(trait.toNode()));
                events.add(event);
                continue;
            }
            NumberNode number = trait.toNode().asNumberNode().get();
            if (number.isFloatingPointNumber()) {
                events.add(this.error((Shape)member, trait, "intEnum members do not support floating point values: " + number.getValue()));
                continue;
            }
            long longValue = number.getValue().longValue();
            if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
                events.add(this.error((Shape)member, trait, "intEnum members must fit within an integer, but found: " + longValue));
                continue;
            }
            if (!values.add(number.getValue().intValue())) {
                events.add(this.error(member, String.format("Multiple intEnum members found with duplicate value `%d`", number.getValue().intValue())));
            }
            this.validateEnumMemberName(events, member);
        }
    }

    private ValidationEvent missingIntEnumValue(Shape shape, FromSourceLocation sourceLocation) {
        return this.error(shape, sourceLocation, "intEnum members must be assigned an integer value");
    }

    private void validateEnumMemberName(List<ValidationEvent> events, MemberShape member) {
        if (!RECOMMENDED_NAME_PATTERN.matcher(member.getMemberName()).find()) {
            events.add(this.warning(member, String.format("The name `%s` does not match the recommended enum name format of beginning with an uppercase letter, followed by any number of uppercase letters, numbers, or underscores.", member.getMemberName())));
        }
    }
}

