/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiFunction;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformer;

final class MapTraits {
    private final BiFunction<Shape, Trait, Trait> mapper;

    MapTraits(BiFunction<Shape, Trait, Trait> mapper) {
        this.mapper = mapper;
    }

    Model transform(ModelTransformer transformer, Model model) {
        return transformer.mapShapes(model, this::mapTraits);
    }

    private Shape mapTraits(Shape shape) {
        ArrayList<Trait> traits = new ArrayList<Trait>();
        boolean changed = false;
        for (Trait trait : shape.getAllTraits().values()) {
            Trait mapped = Objects.requireNonNull(this.mapper.apply(shape, trait), "Trait mapper must not return null");
            traits.add(mapped);
            if (mapped.equals(trait)) continue;
            changed = true;
        }
        if (!changed) {
            return shape;
        }
        return (Shape)((AbstractShapeBuilder)((AbstractShapeBuilder)Shape.shapeToBuilder(shape)).clearTraits()).addTraits(traits).build();
    }
}

