/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class ShapeIdConflictValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        int initialCapacity = (int)Math.ceil((double)model.getShapeIds().size() * 0.75 + 1.0);
        HashMap<String, Collection> conflicts = new HashMap<String, Collection>(initialCapacity);
        for (ShapeId id2 : model.getShapeIds()) {
            conflicts.computeIfAbsent(id2.toString().toLowerCase(Locale.ENGLISH), i -> new ArrayList(1)).add(id2);
        }
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Map.Entry entry : conflicts.entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            for (ShapeId value : (Collection)entry.getValue()) {
                String collideString = ((Collection)entry.getValue()).stream().filter(id -> !id.equals(value)).sorted().map(id -> "`" + id + "`").collect(Collectors.joining(", "));
                events.add(this.error(model.expectShape(value), String.format("Shape ID `%s` conflicts with other shape IDs in the model: [%s]", value, collideString)));
            }
        }
        return events;
    }
}

