/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.linters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.UnreferencedShapes;
import software.amazon.smithy.model.node.ExpectationNotMetException;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;

public final class UnreferencedShapeValidator
extends AbstractValidator {
    private final Config config;

    private UnreferencedShapeValidator(Config config) {
        this.config = config;
    }

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Shape shape : new UnreferencedShapes(this.config.rootShapeSelector).compute(model)) {
            events.add(this.note(shape, "This shape is unreferenced. It has no modeled connections to shapes that match the following selector: `" + this.config.rootShapeSelector + "`"));
        }
        return events;
    }

    public static final class Config {
        private Selector rootShapeSelector = Selector.parse("service");

        public Selector getRootShapeSelector() {
            return this.rootShapeSelector;
        }

        public void setRootShapeSelector(Selector rootShapeSelector) {
            this.rootShapeSelector = Objects.requireNonNull(rootShapeSelector);
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(UnreferencedShapeValidator.class, (ObjectNode configuration) -> {
                Config config = new Config();
                ObjectNode node = configuration.expectObjectNode().expectNoAdditionalProperties(Collections.singleton("rootShapeSelector"));
                node.getStringMember("rootShapeSelector").ifPresent(rootShapeNode -> {
                    try {
                        config.setRootShapeSelector(Selector.parse(rootShapeNode.getValue()));
                    }
                    catch (SelectorSyntaxException e) {
                        throw new ExpectationNotMetException("Error parsing `rootShapeSelector`: " + e.getMessage(), (FromSourceLocation)rootShapeNode);
                    }
                });
                return new UnreferencedShapeValidator(config);
            });
        }
    }
}

