/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.StringTrait;

public final class TimestampFormatTrait
extends StringTrait {
    public static final String EPOCH_SECONDS = "epoch-seconds";
    public static final String DATE_TIME = "date-time";
    public static final String HTTP_DATE = "http-date";
    public static final ShapeId ID = ShapeId.from("smithy.api#timestampFormat");

    public TimestampFormatTrait(String value, SourceLocation sourceLocation) {
        super(ID, value, sourceLocation);
    }

    public TimestampFormatTrait(String value) {
        this(value, SourceLocation.NONE);
    }

    public Format getFormat() {
        return Format.fromString(this.getValue());
    }

    public static enum Format {
        EPOCH_SECONDS("epoch-seconds"),
        DATE_TIME("date-time"),
        HTTP_DATE("http-date"),
        UNKNOWN("unknown");

        private String value;

        private Format(String value) {
            this.value = value;
        }

        public static Format fromString(String value) {
            for (Format format : Format.values()) {
                if (!format.value.equals(value)) continue;
                return format;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.value;
        }
    }

    public static final class Provider
    extends StringTrait.Provider<TimestampFormatTrait> {
        public Provider() {
            super(ID, TimestampFormatTrait::new);
        }
    }
}

