/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.TextInstance;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.ReferencesTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.SmithyUnstableApi;

@SmithyUnstableApi
public final class TextIndex
implements KnowledgeIndex {
    private final List<TextInstance> textInstanceList = new ArrayList<TextInstance>();

    public TextIndex(Model model) {
        HashSet<String> visitedNamespaces = new HashSet<String>();
        Node validatePreludeNode = model.getMetadata().get("__validatePrelude__");
        boolean validatePrelude = validatePreludeNode != null ? validatePreludeNode.expectBooleanNode().getValue() : false;
        for (Shape shape : model.toSet()) {
            if (!validatePrelude && Prelude.isPreludeShape(shape)) continue;
            if (visitedNamespaces.add(shape.getId().getNamespace())) {
                this.textInstanceList.add(TextInstance.createNamespaceText(shape.getId().getNamespace()));
            }
            TextIndex.computeShapeTextInstances(shape, this.textInstanceList, model);
        }
    }

    public static TextIndex of(Model model) {
        return model.getKnowledge(TextIndex.class, TextIndex::new);
    }

    public Collection<TextInstance> getTextInstances() {
        return Collections.unmodifiableList(this.textInstanceList);
    }

    private static void computeShapeTextInstances(Shape shape, Collection<TextInstance> textInstances, Model model) {
        textInstances.add(TextInstance.createShapeInstance(shape));
        for (Trait trait : shape.getAllTraits().values()) {
            model.getShape(trait.toShapeId()).ifPresent(traitShape -> TextIndex.computeTextInstancesForAppliedTrait(trait.toNode(), trait, shape, textInstances, new ArrayDeque<String>(), model, traitShape));
        }
    }

    private static void computeTextInstancesForAppliedTrait(Node node, Trait trait, Shape parentShape, Collection<TextInstance> textInstances, Deque<String> propertyPath, Model model, Shape currentTraitPropertyShape) {
        if (!trait.toShapeId().equals(ReferencesTrait.ID)) {
            if (node.isStringNode()) {
                textInstances.add(TextInstance.createTraitInstance(node.expectStringNode().getValue(), parentShape, trait, propertyPath));
            } else if (node.isObjectNode()) {
                ObjectNode objectNode = node.expectObjectNode();
                objectNode.getStringMap().entrySet().forEach(memberEntry -> {
                    propertyPath.offerLast((String)memberEntry.getKey());
                    Shape memberTypeShape = TextIndex.getChildMemberShapeType((String)memberEntry.getKey(), model, currentTraitPropertyShape);
                    if (memberTypeShape == null) {
                        propertyPath.offerLast("key");
                        textInstances.add(TextInstance.createTraitInstance((String)memberEntry.getKey(), parentShape, trait, propertyPath));
                        propertyPath.removeLast();
                    }
                    TextIndex.computeTextInstancesForAppliedTrait((Node)memberEntry.getValue(), trait, parentShape, textInstances, propertyPath, model, memberTypeShape);
                    propertyPath.removeLast();
                });
            } else if (node.isArrayNode()) {
                int index = 0;
                for (Node nodeElement : node.expectArrayNode().getElements()) {
                    propertyPath.offerLast(Integer.toString(index));
                    Shape memberTypeShape = TextIndex.getChildMemberShapeType(null, model, currentTraitPropertyShape);
                    TextIndex.computeTextInstancesForAppliedTrait(nodeElement, trait, parentShape, textInstances, propertyPath, model, memberTypeShape);
                    propertyPath.removeLast();
                    ++index;
                }
            }
        }
    }

    private static Shape getChildMemberShapeType(String memberKey, Model model, Shape fromShape) {
        if (fromShape != null) {
            for (MemberShape member : fromShape.members()) {
                if (!member.getMemberName().equals(memberKey)) continue;
                return model.getShape(member.getTarget()).get();
            }
        }
        return null;
    }
}

