/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation;

import java.util.Arrays;
import java.util.Optional;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;

public enum Severity implements ToNode
{
    SUPPRESSED,
    NOTE,
    WARNING,
    DANGER,
    ERROR;

    private static final String[] NAMES;

    public boolean canSuppress() {
        return this != ERROR && this != SUPPRESSED;
    }

    public static Optional<Severity> fromString(String text) {
        return Arrays.stream(Severity.values()).filter(value -> value.toString().equals(text)).findFirst();
    }

    public static Severity fromNode(Node node) {
        String value = node.expectStringNode().expectOneOf(NAMES);
        return Severity.valueOf(value);
    }

    @Override
    public Node toNode() {
        return Node.from(this.toString());
    }

    static {
        NAMES = new String[]{"SUPPRESSED", "NOTE", "WARNING", "DANGER", "ERROR"};
    }
}

