/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AuthDefinitionTrait;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.traits.OptionalAuthTrait;
import software.amazon.smithy.model.traits.ProtocolDefinitionTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.synthetic.NoAuthTrait;
import software.amazon.smithy.utils.MapUtils;

public final class ServiceIndex
implements KnowledgeIndex {
    private final WeakReference<Model> model;
    private final Set<ShapeId> protocolTraits = new HashSet<ShapeId>();
    private final Set<ShapeId> authTraits = new HashSet<ShapeId>();

    public ServiceIndex(Model model) {
        this.model = new WeakReference<Model>(model);
        for (Shape shape : model.getShapesWithTrait(ProtocolDefinitionTrait.class)) {
            this.protocolTraits.add(shape.getId());
        }
        for (Shape shape : model.getShapesWithTrait(AuthDefinitionTrait.class)) {
            this.authTraits.add(shape.getId());
        }
    }

    public static ServiceIndex of(Model model) {
        return model.getKnowledge(ServiceIndex.class, ServiceIndex::new);
    }

    public Map<ShapeId, Trait> getProtocols(ToShapeId service) {
        return this.getTraitMapInSet(service, this.protocolTraits);
    }

    private Map<ShapeId, Trait> getTraitMapInSet(ToShapeId service, Set<ShapeId> haystack) {
        return this.getModel().getShape(service.toShapeId()).flatMap(Shape::asServiceShape).map(shape -> {
            TreeMap<ShapeId, Trait> result = new TreeMap<ShapeId, Trait>();
            for (Trait trait : shape.getAllTraits().values()) {
                if (!haystack.contains(trait.toShapeId())) continue;
                result.put(trait.toShapeId(), trait);
            }
            return result;
        }).orElse(Collections.emptyMap());
    }

    private Model getModel() {
        return Objects.requireNonNull((Model)this.model.get(), "The dereferenced WeakReference<Model> is null");
    }

    public Map<ShapeId, Trait> getAuthSchemes(ToShapeId service) {
        return this.getTraitMapInSet(service, this.authTraits);
    }

    public Map<ShapeId, Trait> getEffectiveAuthSchemes(ToShapeId service) {
        return this.getModel().getShape(service.toShapeId()).flatMap(Shape::asServiceShape).map(shape -> {
            Map<ShapeId, Trait> result = ServiceIndex.getAuthTraitValues(shape, shape);
            if (result == null) {
                result = new TreeMap<ShapeId, Trait>();
                for (Map.Entry<ShapeId, Trait> traitEntry : shape.getAllTraits().entrySet()) {
                    if (!this.authTraits.contains(traitEntry.getKey())) continue;
                    result.put(traitEntry.getKey(), traitEntry.getValue());
                }
            }
            return result;
        }).orElse(Collections.emptyMap());
    }

    public Map<ShapeId, Trait> getEffectiveAuthSchemes(ToShapeId service, AuthSchemeMode authSchemeMode) {
        Map authSchemes = this.getEffectiveAuthSchemes(service);
        if (authSchemeMode == AuthSchemeMode.NO_AUTH_AWARE && authSchemes.isEmpty()) {
            authSchemes = MapUtils.of((Object)NoAuthTrait.ID, (Object)new NoAuthTrait());
        }
        return authSchemes;
    }

    public Map<ShapeId, Trait> getEffectiveAuthSchemes(ToShapeId service, ToShapeId operation) {
        Shape serviceShape = this.getModel().getShape(service.toShapeId()).flatMap(Shape::asServiceShape).orElse(null);
        if (serviceShape == null) {
            return Collections.emptyMap();
        }
        return this.getModel().getShape(operation.toShapeId()).flatMap(Shape::asOperationShape).map(operationShape -> {
            Map<ShapeId, Trait> result = ServiceIndex.getAuthTraitValues(serviceShape, operationShape);
            return result != null ? result : this.getEffectiveAuthSchemes(service);
        }).orElse(Collections.emptyMap());
    }

    public Map<ShapeId, Trait> getEffectiveAuthSchemes(ToShapeId service, ToShapeId operation, AuthSchemeMode authSchemeMode) {
        Map<ShapeId, Trait> authSchemes = this.getEffectiveAuthSchemes(service, operation);
        if (authSchemeMode == AuthSchemeMode.NO_AUTH_AWARE && (authSchemes.isEmpty() || this.hasOptionalAuth(operation))) {
            authSchemes = new LinkedHashMap<ShapeId, Trait>(authSchemes);
            authSchemes.put(NoAuthTrait.ID, new NoAuthTrait());
        }
        return authSchemes;
    }

    private boolean hasOptionalAuth(ToShapeId operation) {
        return this.getModel().getShape(operation.toShapeId()).filter(shape -> shape.hasTrait(OptionalAuthTrait.class)).isPresent();
    }

    private static Map<ShapeId, Trait> getAuthTraitValues(Shape service, Shape subject) {
        if (!subject.hasTrait(AuthTrait.class)) {
            return null;
        }
        AuthTrait authTrait = subject.expectTrait(AuthTrait.class);
        LinkedHashMap<ShapeId, Trait> result = new LinkedHashMap<ShapeId, Trait>();
        for (ShapeId value : authTrait.getValueSet()) {
            service.findTrait(value).ifPresent(trait -> result.put(value, (Trait)trait));
        }
        return result;
    }

    public static enum AuthSchemeMode {
        MODELED,
        NO_AUTH_AWARE;

    }
}

