/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model;

import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.SourceLocation;

public class SourceException
extends RuntimeException
implements FromSourceLocation {
    private final transient SourceLocation sourceLocation;

    public SourceException(String message, FromSourceLocation sourceLocation, Throwable cause) {
        super(SourceException.createMessage(message, sourceLocation.getSourceLocation()), cause);
        this.sourceLocation = sourceLocation.getSourceLocation();
    }

    public SourceException(String message, FromSourceLocation sourceLocation) {
        super(SourceException.createMessage(message, sourceLocation.getSourceLocation()));
        this.sourceLocation = sourceLocation.getSourceLocation();
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    private static String createMessage(String message, SourceLocation sourceLocation) {
        if (sourceLocation == SourceLocation.NONE) {
            return message;
        }
        String asString = sourceLocation.toString();
        return message.contains(asString) ? message : message + " (" + asString + ")";
    }

    public String getMessageWithoutLocation() {
        return this.getMessage().replace(" (" + this.sourceLocation + ")", "");
    }
}

