/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.stream.Stream;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public interface Trait
extends FromSourceLocation,
ToNode,
ToShapeId {
    @Override
    public ShapeId toShapeId();

    default public boolean isSynthetic() {
        return false;
    }

    @Deprecated
    public static <S extends Shape, T extends Trait> Stream<Pair<S, T>> flatMapStream(S shape, Class<T> traitClass) {
        return OptionalUtils.stream(shape.getTrait(traitClass).map(t -> Pair.of((Object)shape, (Object)t)));
    }

    public static String getIdiomaticTraitName(String traitName) {
        return traitName.startsWith("smithy.api#") ? traitName.substring("smithy.api#".length()) : traitName;
    }

    public static String getIdiomaticTraitName(ToShapeId id) {
        return Trait.getIdiomaticTraitName(id.toShapeId().toString());
    }

    public static String makeAbsoluteName(String traitName) {
        return Trait.makeAbsoluteName(traitName, "smithy.api");
    }

    public static String makeAbsoluteName(String traitName, String defaultNamespace) {
        return traitName.contains("#") ? traitName : defaultNamespace + "#" + traitName;
    }
}

