/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.nio.CharBuffer;
import java.util.Iterator;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.DefaultTokenizer;
import software.amazon.smithy.model.loader.IdlToken;
import software.amazon.smithy.model.loader.LoaderUtils;

public interface IdlTokenizer
extends Iterator<IdlToken> {
    public static IdlTokenizer create(CharSequence model) {
        return IdlTokenizer.create(SourceLocation.NONE.getFilename(), model);
    }

    public static IdlTokenizer create(String filename, CharSequence model) {
        return new DefaultTokenizer(filename, model);
    }

    public String getSourceFilename();

    public CharSequence getModel();

    default public CharSequence getModel(int start, int end) {
        return CharBuffer.wrap(this.getModel(), start, end);
    }

    public int getPosition();

    public int getLine();

    public int getColumn();

    public IdlToken getCurrentToken();

    public int getCurrentTokenLine();

    public int getCurrentTokenColumn();

    public int getCurrentTokenStart();

    public int getCurrentTokenEnd();

    default public int getCurrentTokenSpan() {
        return this.getCurrentTokenEnd() - this.getCurrentTokenStart();
    }

    default public SourceLocation getCurrentTokenLocation() {
        return new SourceLocation(this.getSourceFilename(), this.getCurrentTokenLine(), this.getCurrentTokenColumn());
    }

    default public CharSequence getCurrentTokenLexeme() {
        return this.getModel(this.getCurrentTokenStart(), this.getCurrentTokenEnd());
    }

    public CharSequence getCurrentTokenStringSlice();

    public Number getCurrentTokenNumberValue();

    public String getCurrentTokenError();

    default public void expect(IdlToken token) {
        if (this.getCurrentToken() != token) {
            throw LoaderUtils.idlSyntaxError(LoaderUtils.idlExpectMessage(this, token), this.getCurrentTokenLocation());
        }
    }

    default public IdlToken expect(IdlToken ... tokens) {
        IdlToken currentTokenType = this.getCurrentToken();
        for (IdlToken token : tokens) {
            if (currentTokenType != token) continue;
            return token;
        }
        throw LoaderUtils.idlSyntaxError(LoaderUtils.idlExpectMessage(this, tokens), this.getCurrentTokenLocation());
    }

    default public boolean isCurrentLexeme(CharSequence chars) {
        CharSequence lexeme = this.getCurrentTokenLexeme();
        int testLength = chars.length();
        if (lexeme.length() != testLength) {
            return false;
        }
        for (int i = 0; i < testLength; ++i) {
            if (lexeme.charAt(i) == chars.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

