/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model;

import java.util.Objects;
import software.amazon.smithy.model.FromSourceLocation;

public final class SourceLocation
implements FromSourceLocation,
Comparable<SourceLocation> {
    public static final SourceLocation NONE = new SourceLocation("N/A");
    private final String filename;
    private final int line;
    private final int column;
    private int hash;

    public SourceLocation(String filename, int line, int column) {
        this.filename = Objects.requireNonNull(filename);
        this.line = line;
        this.column = column;
    }

    public SourceLocation(String filename) {
        this(filename, 0, 0);
    }

    public static SourceLocation none() {
        return NONE;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this;
    }

    public String toString() {
        return this.filename.isEmpty() ? String.format("[%d, %d]", this.line, this.column) : String.format("%s [%d, %d]", this.filename, this.line, this.column);
    }

    public boolean equals(Object other) {
        return other instanceof SourceLocation && this.toString().equals(other.toString());
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = 1 + this.filename.hashCode() + this.line * 17 + this.column;
        }
        return h;
    }

    @Override
    public int compareTo(SourceLocation o) {
        if (!this.getFilename().equals(o.getFilename())) {
            return this.getFilename().compareTo(o.getFilename());
        }
        int lineComparison = Integer.compare(this.getLine(), o.getLine());
        if (lineComparison != 0) {
            return lineComparison;
        }
        return Integer.compare(this.getColumn(), o.getColumn());
    }
}

