/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.HttpErrorTrait;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.transform.ModelTransformException;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.utils.Pair;

final class DeconflictErrorsWithSharedStatusCode {
    private final ServiceShape forService;

    DeconflictErrorsWithSharedStatusCode(ServiceShape forService) {
        this.forService = forService;
    }

    Model transform(ModelTransformer transformer, Model model) {
        model = transformer.copyServiceErrorsToOperations(model, this.forService);
        TopDownIndex topDownIndex = TopDownIndex.of(model);
        ArrayList<Shape> shapesToReplace = new ArrayList<Shape>();
        for (OperationShape operation : topDownIndex.getContainedOperations(this.forService)) {
            OperationShape.Builder replacementOperation = operation.toBuilder();
            boolean replaceOperation = false;
            HashMap<Integer, List> statusCodesToErrors = new HashMap<Integer, List>();
            for (ShapeId shapeId : operation.getErrors()) {
                StructureShape error = model.expectShape(shapeId, StructureShape.class);
                Integer statusCode = error.hasTrait(HttpErrorTrait.ID) ? error.getTrait(HttpErrorTrait.class).get().getCode() : error.getTrait(ErrorTrait.class).get().getDefaultHttpStatusCode();
                statusCodesToErrors.computeIfAbsent(statusCode, k -> new ArrayList()).add(error);
            }
            for (Map.Entry entry : statusCodesToErrors.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                replaceOperation = true;
                List errors = (List)entry.getValue();
                Pair<Shape, List<Shape>> syntheticErrorPair = this.synthesizeErrorUnion(operation.getId().getName(), (Integer)entry.getKey(), errors);
                for (StructureShape error : errors) {
                    replacementOperation.removeError(error.getId());
                }
                replacementOperation.addError((ToShapeId)syntheticErrorPair.getLeft());
                shapesToReplace.add((Shape)syntheticErrorPair.getLeft());
                shapesToReplace.addAll((Collection)syntheticErrorPair.getRight());
            }
            if (!replaceOperation) continue;
            replacementOperation.build();
            shapesToReplace.add(replacementOperation.build());
        }
        return transformer.replaceShapes(model, shapesToReplace);
    }

    private Pair<Shape, List<Shape>> synthesizeErrorUnion(String operationName, Integer statusCode, List<StructureShape> errors) {
        ArrayList<Shape> replacementShapes = new ArrayList<Shape>();
        StructureShape.Builder errorResponse = StructureShape.builder();
        ShapeId errorResponseId = ShapeId.fromParts(this.forService.getId().getNamespace(), operationName + statusCode + "Error");
        errorResponse.id(errorResponseId);
        errorResponse.addTraits(this.getErrorTraitsFromStatusCode(statusCode));
        HashMap<String, HttpHeaderTrait> headerTraitMap = new HashMap<String, HttpHeaderTrait>();
        UnionShape.Builder errorUnion = (UnionShape.Builder)UnionShape.builder().id(ShapeId.fromParts(errorResponseId.getNamespace(), errorResponseId.getName() + "Content"));
        for (StructureShape structureShape : errors) {
            StructureShape structureShape2 = this.createNewError(structureShape, headerTraitMap);
            replacementShapes.add(structureShape2);
            MemberShape newErrorMember = ((MemberShape.Builder)MemberShape.builder().id(errorUnion.getId().withMember(structureShape2.getId().getName()))).target(structureShape2.getId()).build();
            replacementShapes.add(newErrorMember);
            errorUnion.addMember(newErrorMember);
        }
        UnionShape union = errorUnion.build();
        replacementShapes.add(union);
        errorResponse.addMember(((MemberShape.Builder)MemberShape.builder().id(errorResponseId.withMember("errorUnion"))).target(union.getId()).build());
        for (Map.Entry entry : headerTraitMap.entrySet()) {
            errorResponse.addMember(((MemberShape.Builder)((MemberShape.Builder)MemberShape.builder().id(errorResponseId.withMember((String)entry.getKey()))).addTrait((Trait)entry.getValue())).target("smithy.api#String").build());
        }
        StructureShape structureShape = errorResponse.build();
        return Pair.of((Object)structureShape, replacementShapes);
    }

    private StructureShape createNewError(StructureShape oldError, Map<String, HttpHeaderTrait> headerMap) {
        StructureShape.Builder newErrorBuilder = (StructureShape.Builder)oldError.toBuilder().clearMembers();
        for (MemberShape member : oldError.getAllMembers().values()) {
            String name = member.getMemberName();
            if (member.hasTrait(HttpHeaderTrait.ID)) {
                HttpHeaderTrait newTrait = member.expectTrait(HttpHeaderTrait.class);
                HttpHeaderTrait previousTrait = headerMap.put(name, newTrait);
                if (previousTrait == null || previousTrait.equals(newTrait)) continue;
                throw new ModelTransformException("Conflicting header when de-conflicting");
            }
            newErrorBuilder.addMember(((MemberShape.Builder)member.toBuilder().id(newErrorBuilder.getId().withMember(name))).build());
        }
        return newErrorBuilder.build();
    }

    private List<Trait> getErrorTraitsFromStatusCode(Integer statusCode) {
        ArrayList<Trait> traits = new ArrayList<Trait>();
        if (statusCode >= 400 && statusCode < 500) {
            traits.add(new ErrorTrait("client"));
        } else {
            traits.add(new ErrorTrait("server"));
        }
        traits.add(new HttpErrorTrait(statusCode));
        return traits;
    }
}

