/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.Context;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.selector.IsSelector;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;

final class NeighborSelector
implements InternalSelector {
    static final NeighborSelector FORWARD = new NeighborSelector(Collections.emptyList(), Direction.FORWARD);
    static final NeighborSelector REVERSE = new NeighborSelector(Collections.emptyList(), Direction.REVERSE);
    private final List<String> relTypes;
    private final Direction direction;
    private final Function<Context, NeighborProvider> neighborFactory;

    private NeighborSelector(List<String> relTypes, Direction direction) {
        this.relTypes = Objects.requireNonNull(relTypes);
        this.direction = direction;
        boolean includeTraits = relTypes.contains("trait");
        this.neighborFactory = direction.neighborFactory(includeTraits);
    }

    static InternalSelector forward(List<String> relationships) {
        return NeighborSelector.fromStrings(relationships, Direction.FORWARD);
    }

    static InternalSelector reverse(List<String> relationships) {
        return NeighborSelector.fromStrings(relationships, Direction.REVERSE);
    }

    private static InternalSelector fromStrings(List<String> relationships, Direction direction) {
        boolean bound = relationships.removeIf(r -> r.equals("bound"));
        boolean instanceOperation = relationships.removeIf(r -> r.equals("instanceOperation"));
        if (!bound && !instanceOperation) {
            return new NeighborSelector(relationships, direction);
        }
        ArrayList<InternalSelector> predicates = new ArrayList<InternalSelector>(1 + (bound ? 1 : 0) + (instanceOperation ? 1 : 0));
        if (!relationships.isEmpty()) {
            predicates.add(new NeighborSelector(relationships, direction));
        }
        if (bound) {
            predicates.add(new BoundRelationship());
        }
        if (instanceOperation) {
            boolean traits = relationships.contains("trait");
            predicates.add(new InstanceOperationRelationship(direction, direction.neighborFactory(traits)));
        }
        return IsSelector.of(predicates);
    }

    @Override
    public InternalSelector.Response push(Context context, Shape shape, InternalSelector.Receiver next) {
        NeighborProvider resolvedProvider = this.neighborFactory.apply(context);
        for (Relationship rel : resolvedProvider.getNeighbors(shape)) {
            if (!this.matches(rel) || this.direction.emit(context, rel, next) != InternalSelector.Response.STOP) continue;
            return InternalSelector.Response.STOP;
        }
        return InternalSelector.Response.CONTINUE;
    }

    private boolean matches(Relationship rel) {
        return rel.getRelationshipType() != RelationshipType.MEMBER_CONTAINER && rel.getNeighborShape().isPresent() && NeighborSelector.relTypesMatchesRel(this.relTypes, rel);
    }

    private static boolean relTypesMatchesRel(List<String> relTypes, Relationship rel) {
        if (relTypes.isEmpty()) {
            return true;
        }
        String relType = rel.getSelectorLabel().orElse("");
        return relTypes.contains(relType);
    }

    private static enum Direction {
        FORWARD{

            @Override
            protected InternalSelector.Response emit(Context context, Relationship rel, InternalSelector.Receiver next) {
                return next.apply(context, rel.expectNeighborShape());
            }

            @Override
            protected Function<Context, NeighborProvider> neighborFactory(boolean includeTraits) {
                return includeTraits ? context -> context.neighborIndex.getProviderWithTraitRelationships() : context -> context.neighborIndex.getProvider();
            }
        }
        ,
        REVERSE{

            @Override
            protected InternalSelector.Response emit(Context context, Relationship rel, InternalSelector.Receiver next) {
                return next.apply(context, rel.getShape());
            }

            @Override
            protected Function<Context, NeighborProvider> neighborFactory(boolean includeTraits) {
                return includeTraits ? context -> context.neighborIndex.getReverseProviderWithTraitRelationships() : context -> context.neighborIndex.getReverseProvider();
            }
        };


        protected abstract InternalSelector.Response emit(Context var1, Relationship var2, InternalSelector.Receiver var3);

        protected abstract Function<Context, NeighborProvider> neighborFactory(boolean var1);
    }

    @Deprecated
    private static final class BoundRelationship
    implements InternalSelector {
        private BoundRelationship() {
        }

        @Override
        public InternalSelector.Response push(Context ctx, Shape shape, InternalSelector.Receiver next) {
            if (shape.isResourceShape()) {
                for (ResourceShape resource : ctx.getModel().getResourceShapes()) {
                    if (!resource.getResources().contains(shape.getId()) || next.apply(ctx, resource) != InternalSelector.Response.STOP) continue;
                    return InternalSelector.Response.STOP;
                }
                for (ServiceShape service : ctx.getModel().getServiceShapes()) {
                    if (!service.getResources().contains(shape.getId()) || next.apply(ctx, service) != InternalSelector.Response.STOP) continue;
                    return InternalSelector.Response.STOP;
                }
            }
            return InternalSelector.Response.CONTINUE;
        }
    }

    @Deprecated
    private static final class InstanceOperationRelationship
    implements InternalSelector {
        private final Direction direction;
        private final Function<Context, NeighborProvider> neighborFactory;

        InstanceOperationRelationship(Direction direction, Function<Context, NeighborProvider> neighborFactory) {
            this.direction = direction;
            this.neighborFactory = neighborFactory;
        }

        @Override
        public InternalSelector.Response push(Context ctx, Shape shape, InternalSelector.Receiver next) {
            if (shape.isResourceShape()) {
                NeighborProvider resolvedProvider = this.neighborFactory.apply(ctx);
                for (Relationship rel : resolvedProvider.getNeighbors(shape)) {
                    if (!rel.getRelationshipType().isInstanceOperationBinding() || this.direction.emit(ctx, rel, next) != InternalSelector.Response.STOP) continue;
                    return InternalSelector.Response.STOP;
                }
            }
            return InternalSelector.Response.CONTINUE;
        }
    }
}

